unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Parser;

type
  TMainForm = class(TForm)
    LB1: TListBox;
    Button1: TButton;
    FP1: TFileParser;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Label1: TLabel;
    labCount: TLabel;
    CheckBox4: TCheckBox;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Button2: TButton;
    procedure FP1RecordParse(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FP1RecordParse(Sender: TObject);
begin
    LB1.Items := FP1.ParseList;
    LabCount.Caption := IntToStr(FP1.FieldCount);
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
    FP1.ParseFile;
end;

procedure TMainForm.CheckBox1Click(Sender: TObject);
begin
    FP1.IgnoreLeadingDelimiters := Not FP1.IgnoreLeadingDelimiters;
end;

procedure TMainForm.CheckBox2Click(Sender: TObject);
begin
    FP1.IgnoreMultiDelimiters := Not FP1.IgnoreMultiDelimiters;
end;

procedure TMainForm.CheckBox3Click(Sender: TObject);
begin
     FP1.IgnoreTrailingDelimiters := Not FP1.IgnoreTrailingDelimiters;

end;

procedure TMainForm.CheckBox4Click(Sender: TObject);
begin
     FP1.TrimTextQualifiers := Not FP1.TrimTextQualifiers;

end;

procedure TMainForm.Edit1Change(Sender: TObject);
begin
    FP1.FieldDelimiters := Edit1.Text;
end;

procedure TMainForm.Edit2Change(Sender: TObject);
begin
    FP1.TextQualifiers := Edit2.Text;
end;

end.
