#ifndef _DES16_H_
#define _DES16_H_

/*
 *             des16 - NBS Data Encryption Standard Library
 *
 *         Copyright (c) 1992,93,94 by SWS. All Rights Reserved.
 *       Stefan Wolf Software; Gartenstr 22; D-61449 Steinbach/Ts.
 *           FAX: +49 (0) 6171 980483; CI$ Email: 100111,140
 *
 *  DES in ECB mode handles data blocks of 64 bits at one time. DES is 
 *  basically a bit permutation, substitution, and recombination function 
 *  performed on blocks of 64 bits of data and 56 bits of key (eight 7-bit 
 *  characters).
 *
 *  First, the 64 bit inputblock is subjected to a fixed initial permutation
 *  IP and split into two 32 bit blocks L_0_ and R_0_. Then each block is 
 *  hacked apart in 16 iterations. The resulting 32 bit blocks L_16_ and 
 *  R_16_ are then permuted back to a 64 bit block by a permutation table IP' 
 *  which is the inverse of IP. The resulting 64 bit encrypted block is then 
 *  written to the output block.
 *
 *  [technical stuff on]
 *  In each iteration I_i_ the block L_i-1_ is coupled with the 32 bit 
 *  output of the function f(R_i-1_,k_i_) by an XOR operation. The 
 *  iteration I_16_ is an exception, here the blocks are swapped. The 
 *  function f() receives the block R_i-1_ and the 48 bit output of the 
 *  function K(i) as its arguments. f() permutes the 32 bits of R_i-1_ 
 *  into 48 bits by using the permutation table E. The result is exclusive
 *  ORed with the 48 bit output from the function K(i). The 48 bit result 
 *  is then split into eight 6 bit values. Then the function S realizes 
 *  a 4 bit value for each 6 bit value by an nonlineare substitution. The 
 *  eight 4 bit values are then combined to a 32 bit value, which is then 
 *  coupled with the permutation table P. The resulting 32 bit is the 
 *  output of f(). The function S composed of eight substitution modules 
 *  s1,s2,...,s8 (the mysterious S-boxes) which are used on the eight 6 
 *  bit values from above. In this 16x4 matrix each of the 64 elements 
 *  has a value between 0 and 15, a 4 bit value which substitutes a 6 bit 
 *  value. The matrix coordinates of a 6 bit value are obtained in the 
 *  following manner: bits 1 and 6 as binary give column 0..3, with 
 *  bits 2 through 5 the row  0..15 is calculated. The function S returns 
 *  the 4 bit value of the so addressed matrix element. The function K(i)
 *  returns the 48 bit value k_i_ based on the key. There are two further 
 *  permutation tables for the key. In the first iteration the key is 
 *  permuted with the first table and then split into two halves. Each of 
 *  these halves is shifted to the left once (_i_ = 1,2,9,16) or twice 
 *  depending on the iteration number _i_. Each subsequent iteration I_i_ 
 *  after the first uses the shifted value of the preceding iteration as 
 *  input, shifts the value again and finally permutes it with the second 
 *  permutation table. The decryption process uses the same algorithm, 
 *  except that the decryption reverses the half exchanges during the 
 *  iterations and uses the permuted key values returned by K(i) in 
 *  the reverse order.
 *  [technical stuff off]
 *
 *  It can be shown that after a few iteration steps each bit in the output 
 *  block is dependent upon every bit of the input block and the key. 
 *  A minimal change in the input block or in the key causes more than half 
 *  of the bits in the output block to change, this is the so-called avalanche 
 *  effect. To crack the output block a frequency analysis is no use and a 
 *  potential hacker can only use brute-force methods for key search. This 
 *  means that theoretically 72 quadrillion keys have to be tried.
 *
 *
 *    Synopsis:	desinit(key)
 * Description: intializes all DES arrays and permutation tables
 *       Input: key - 64-bit DES key
 *      Output: none
 *
 *    Synopsis: des_xx_code(inblock,outblock)
 * Description: encrypts (_xx_=en) or decrypts (_xx_=de) 
 *              64-bit inblock to 64-bit outblock
 *	 Input: inblock - pointer to 64-bit buffer of input data
 *              outblock - pointer to 64-bit buffer for output data
 *      Output: none        
 *                 
 */

typedef unsigned char uchar;

extern void far pascal desinit(uchar far *key);
extern void far pascal desencode(uchar far *inblock, uchar far *outblock);
extern void far pascal desdecode(uchar far *inblock, uchar far *outblock);

#endif