msgdivisionbegin 1 transient DIVISION: Tesla's Local Message Areas

%           ----------------------------------------------
%           MSGAREA.CTL - sample message area control file
%           ----------------------------------------------
%
%
%  This file describes your system's message areas.  Each message
%  area can be given a name.  This name consists of letters,
%  numbers, and any of the following characters:
%
%       . / _ ~ ! @ # $ % ^ & * ( ) - + = |
%
%  WARNING!  If you happen to "renumber" the area numbers within this
%  file (such as by changing message area 2 to area 1, and then changing
%  area 3 to area 2, and so on), make sure to delete \MAX\MTAG.* and
%  \MAX\OLR\DATS\*.*.  This is only a concern when changing the
%  name/number of every area; those two files contain information about
%  tagged message areas and the QWK area pointers.  If you change many
%  area numbers without deleting these files, uploaded QWK messages and
%  message tagging information may be incorrect.
% By default, area 1 is used for storing log-off comments.  If
% you wish to change the name or number of this area, you must
% adjust the "Comment Area" option in MAX.CTL.
  
MsgArea 1
        % The 'ACS' keyword defines the privilege level required to
        % access this area.  If the user's priv is not high enough, they
        % won't be able to get in to this area, and Max will pretend
        % that it doesn't even exist.

        ACS         Demoted

        % The Style keyword sets various options for this message area.
        % Many different attributes can be specified on one "style" line.
        %
        % FILE FORMAT.  Only one of the next two options may be specified:
        %
        %       Squish          Use the Squish file format for storing
        %                       messages in this area.  This is the default.
        %
        %       *.MSG           Use the FidoNet-standard *.MSG format for
        %                       storing messages in this area.
        %
        % DISTRIBUTION.  Only one of the next four options may be specified:
        %
        %       Local           This is a local message area.  Messages
        %                       entered in this area do not leave your
        %                       system.
        %
        %       Net             This is a NetMail area.  Areas of this
        %                       type are used for private, point-to-point
        %                       communication with users on remote system.
        %
        %       Echo            This is an EchoMail area.  Messages
        %                       entered in this area will be broadcast
        %                       to all nodes which receive the area.  In
        %                       addition, messages entered here will have a
        %                       tear and origin line appended automatically.
        %
        %       Conf            This is a conference area.  Messages
        %                       entered in this area will be broadcast to
        %                       all node swhich receive the area.  In
        %                       addition, messages entered here will have a
        %                       PID kludge appended automatically.
        %
        % MESSAGE VISIBILITY.  Either or both of the following options
        % may be specified:
        %
        %       Pub             Allow public messages in this area.
        %                       Public messages can be read by all
        %                       users.
        %
        %       Pvt             Allow private messages in this area.
        %                       Private mesasges can only be read
        %                       by the sysop and the addressee.
        %
        % Note that both "Pub" and "Pvt" can be specified to permit
        % both types of messages.
        %
        % MISCELLANEOUS OPTIONS.  See the documentation for detailed
        % information on the use of these options.
        %
        % HighBit       - support 8-bit characters in this area
        % Anon          - allow anonymous messages
        % ReadOnly      - do not allow message posting
        % NoNameKludge  - do not add kludge containing user's real name
        % RealName      - force the use of user's real name
        % Alias         - force the user of user's alias
        % Audit         - message auditing features for this area
        % Hidden        - area is not visible on menu

        Style       Squish Local Pvt Attach

        % The Desc keyword gives a verbose description of the message
        % appear.  This will be shown to users who enter the area.  The
        % description must be less than 60 characters long.

        Desc        Comments to SysOp / Private Local Email

        % The 'Path' keyword tells Maximus where to store the messages
        % in this area.  For *.MSG-format areas, a directory will
        % be created using this name.  For Squish-format areas,
        % the path is treated as a base filename, and a number of
        % extensions will be added.

        Path        H:\Msg\Locl\Private

        % The following options are also commonly used.  See
        % the program documentation for information on other area
        % keywords:
        %
        % Barricade <menu_name> <barricade_file>
        % 
        %   This can be used to selectively adjust users' priv levels
        %   when they enter this area.  Please see the program
        %   documentation for more information.
        % 
        % MenuName <orig_menu> <new_menu>
        % 
        %   This keyword instructs Max to use a special menu for this
        %   area only.  When the user has this message area selected,
        %   whenever a system function tries to display <orig_menu>
        %   (typically the MESSAGE menu), Maximus will substitute
        %   <new_menu> instead.
        % 
        % Override <menu_name> <option_type> <ACS> [letter]
        % 
        %   This option can be used to adjust the privilege level of
        %   a menu option for one message area only.  Please see
        %   the program documentation for more information.
        % 
        % Renum Max <msgs>
        % Renum Days <days>
        % 
        %   These two options can be used to selectively purge
        %   messages from the message areas with an automated
        %   program.  Please see the program documentation for
        %   more details.

        Renum Max   200
End MsgArea

MsgArea 2
        ACS         Disgrace
        Style       Squish Local Pub Pvt Attach
        Desc        Local:General
        Path        H:\Msg\Locl\General
        Renum Max   200
End MsgArea

MsgArea 3
        ACS         Disgrace
        Style       Squish Local Pub Pvt Attach
        Desc        Local:Intros
        Path        H:\Msg\Locl\Intros
        Renum Max   300
End MsgArea

MsgArea 4
        ACS         Disgrace
        Style       Squish Local Pub Pvt Attach
        Desc        Local:BBSAdds
        Path        H:\Msg\Locl\Bbsadds
        Renum Max   300
End MsgArea

MsgArea 5
        ACS         Disgrace
        Style       Squish Local Pub Pvt Attach
        Desc        Local:BuySell
        Path        H:\Msg\Locl\Buylocl
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin 2 Demoted DIVISION: All FidoNet Echoes

msgdivisionbegin Fido-A Demoted DIVISION: FidoNet Areas 1-999

MsgArea 4DOS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: 4DOS
        Tag         4DOS
        Path        H:\Msg\Fido\1\4dos
        Renum Max   100
End MsgArea

MsgArea 80XXX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Assembly Language Progrmng(Intel CPU)
        Tag         80XXX
        Path        H:\Msg\Fido\1\80xxx
        Renum Max   500
End MsgArea

MsgArea 4SALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        Region17 Echo: 4 Sale Echo
        Tag         4SALE
        Path        J:\Msg3\Regn17\4sale
        Renum Max   100
End MsgArea

MsgArea 10THAMD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: 10th Amendment Discussion
        Tag         10TH_AMD
        Path        H:\Msg\Fido\1\10thamd
        Renum Max   100
End MsgArea

MsgArea STEPS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: 12 Steps Discussion
        Tag         12_STEPS
        Path        H:\Msg\Fido\1\steps
        Renum Max   100
End MsgArea

MsgArea 4DOSTC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: 4DOS TC
        Tag         4DOS_TC
        Path        H:\Msg\Fido\1\4dostc
        Renum Max   300
End MsgArea

MsgArea 4X4
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: 4x4 vehicle discussion
        Tag         4X4
        Path        I:\Msg2\Fido\F\Fourx4
        Renum Max   500
End MsgArea

MsgArea PROGROCK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: 60s / 70s Progressive Rock Music Echo
        Tag         60S_70S_PROGROCK
        Path        H:\Msg\Fido\1\progrock
        Renum Max   100
End MsgArea

MsgArea COMMO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Commo Comms Program
        Tag         {COMMO}
        Path        H:\Msg\Fido\1\commo
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-A Demoted DIVISION: FidoNet Echoes AA-AZ

MsgArea AAGENE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: AA Genealogy
        Tag         AAGENE
        Path        H:\Msg\Fido\A\Aagene
        Renum Max   500
End MsgArea

MsgArea AAOS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: American Atheist Online Services
        Tag         AAOS
        Path        H:\Msg\Fido\A\aaos
        Renum Max   300
End MsgArea

MsgArea ABLED
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: disABLED Users Information Exchange
        Tag         ABLED
        Path        H:\Msg\Fido\A\abled
        Renum Max   100
End MsgArea

MsgArea ABLATHL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Abled Athletes
        Tag         ABLED_ATHLETE
        Path        H:\Msg\Fido\A\ablathl
        Renum Max   100
End MsgArea

MsgArea ABLENEWS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Disability/Medical News, Views, Rsrcs
        Tag         ABLENEWS
        Path        H:\Msg\Fido\A\ablenews
        Renum Max   100
End MsgArea

MsgArea ABORTION
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Abortion Discussion
        Tag         ABORTION
        Path        H:\Msg\Fido\A\abortion
        Renum Max   100
End MsgArea

MsgArea ACAD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International AutoCAD/CAD Conference
        Tag         A_CAD
        Path        H:\Msg\Fido\A\acad
        Renum Max   200
End MsgArea

MsgArea ACCTTAX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Accounting & Taxes
        Tag         ACCT_TAX
        Path        H:\Msg\Fido\A\accttax
        Renum Max   100
End MsgArea

MsgArea ADND
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Advanced Dungeons and Dragons
        Tag         AD&D
        Path        H:\Msg\Fido\A\adnd
        Renum Max   100
End MsgArea

MsgArea ADAM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Adam International Computer Conf
        Tag         ADAM
        Path        H:\Msg\Fido\A\adam
        Renum Max   100
End MsgArea

MsgArea ADAPTEK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Adaptive Technologies
        Tag         ADAPTEK
        Path        H:\Msg\Fido\A\adaptek
        Renum Max   300
End MsgArea

MsgArea ADEPTSYS
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ADEPT SYSOPS
        Tag         ADEPT_SYSOP
        Path        H:\Msg\Fido\A\adeptsys
        Renum Max   300
End MsgArea

MsgArea ADEPTSOF
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ADEPT BBS Software
        Tag         ADEPTSOFT
        Path        H:\Msg\Fido\A\adeptsof
        Renum Max   300
End MsgArea

MsgArea ADLIB
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Computer Soundcard Disc MsgArea
        Tag         ADLIB
        Path        H:\Msg\Fido\A\adlib
        Renum Max   200
End MsgArea

MsgArea ADHD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Attention Deficit Hyperactivity Dis
        Tag         ADHD
        Path        H:\Msg\Fido\A\adhd
        Renum Max   100
End MsgArea

MsgArea ADOPTEE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Adoptees Information Exchange
        Tag         ADOPTEES
        Path        H:\Msg\Fido\A\adoptee
        Renum Max   100
End MsgArea

MsgArea ADS_AN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ADS File Announcements
        Tag         ADS_ANNOUNCE
        Path        H:\Msg\Fido\A\ads_an
        Renum Max   100
End MsgArea

MsgArea AFIXHLP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: AllFix Support Conference
        Tag         ALLFIX_HELP
        Path        H:\Msg\Fido\A\afixhlp
        Renum Max   500
End MsgArea

MsgArea AI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Artificial Intelligence
        Tag         AI
        Path        H:\Msg\Fido\A\Ai
        Renum Max   500
End MsgArea

MsgArea AIRGUN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Airgun Discussion Echo
        Tag         AIRGUN
        Path        H:\Msg\Fido\A\Airgun
        Renum Max   500
End MsgArea

MsgArea ALASKCHT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Alaska CHAT Echo
        Tag         ALASKA_CHAT
        Path        H:\Msg\Fido\A\Alaskcht
        Renum Max   500
End MsgArea

MsgArea AMPUTEE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Amputee Support
        Tag         AMPUTEE
        Path        H:\Msg\Fido\A\amputee
        Renum Max   100
End MsgArea

MsgArea ALTMED
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Alternate Medicine
        Tag         ALTMED
        Path        H:\Msg\Fido\A\Altmed
        Renum Max   300
End MsgArea

MsgArea ANEWS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: News of the US and World
        Tag         ANEWS
        Path        H:\Msg\Fido\A\anews
        Renum Max   500
End MsgArea

MsgArea ANDOC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Animal Doc
        Tag         ANIMAL_DOC
        Path        H:\Msg\Fido\A\andoc
        Renum Max   200
End MsgArea

MsgArea ANIME
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Japanese Animation Conference
        Tag         ANIME
        Path        H:\Msg\Fido\A\anime
        Renum Max   100
End MsgArea

MsgArea ANIMED
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Animal Medicine Discussion MsgArea
        Tag         ANIMED
        Path        H:\Msg\Fido\A\animed
        Renum Max   500
End MsgArea

MsgArea ANXIETY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Anxiety Disorders
        Tag         ANXIETY
        Path        H:\Msg\Fido\A\anxiety
        Renum Max   200
End MsgArea

MsgArea APOGEE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Apogee Support Conference
        Tag         APOGEE
        Path        H:\Msg\Fido\A\apogee
        Renum Max   500
End MsgArea

MsgArea APWORKS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: APWORKS Software Disc
        Tag         APWORKS
        Path        H:\Msg\Fido\A\Apworks
        Renum Max   500
End MsgArea

MsgArea AQUARIUM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Fishkeeping, Fresh and Marine Tanks
        Tag         AQUARIUM
        Path        H:\Msg\Fido\A\aquarium
        Renum Max   200
End MsgArea

MsgArea ARCADE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Arcade
        Tag         ARCADE
        Path        H:\Msg\Fido\A\arcade
        Renum Max   100
End MsgArea

MsgArea ARCHERY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Archery and Hunting
        Tag         ARCHERY
        Path        H:\Msg\Fido\A\archery
        Renum Max   100
End MsgArea

MsgArea ARCSOFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: ARCSOFT Software ??
        Tag         ARCSOFT
        Path        H:\Msg\Fido\A\Arcsoft
        Renum Max   500
End MsgArea

MsgArea ARJ
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ARJ Support Echo
        Tag         ARJ
        Path        H:\Msg\Fido\A\arj
        Renum Max   200
End MsgArea

MsgArea ABRIDGE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ArrowBridge DoorGame Discussion
        Tag         ARROWBRIDGE
        Path        H:\Msg\Fido\A\abridge
        Renum Max   200
End MsgArea

MsgArea AMTRADIO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Amateur Radio
        Tag         AMATEUR_RADIO
        Path        H:\Msg\Fido\A\Amtradio
        Renum Max   500
End MsgArea

MsgArea ANRIGHTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Animal Rights Echo
        Tag         ANIMAL_RIGHTS
        Path        H:\Msg\Fido\A\Anrights
        Renum Max   500
End MsgArea

MsgArea ARTWARE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: TimEd, NetMgr, WIMM Support Conf.
        Tag         ARTWARE
        Path        H:\Msg\Fido\A\artware
        Renum Max   200
End MsgArea

MsgArea ASIANLNK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Asian Link
        Tag         ASIAN_LINK
        Path        H:\Msg\Fido\A\asianlnk
        Renum Max   200
End MsgArea

MsgArea ASKNURSE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Ask Nurses & Others about HealthCare
        Tag         ASK_A_NURSE
        Path        H:\Msg\Fido\A\asknurse
        Renum Max   500
End MsgArea

MsgArea ASKACOP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Ask a Law Enforcement Professional
        Tag         ASKACOP
        Path        H:\Msg\Fido\A\askacop
        Renum Max   100
End MsgArea

MsgArea ASKACOP2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Ask-a-cop 2
        Tag         ASKACOP2
        Path        H:\Msg\Fido\A\askacop2
        Renum Max   200
End MsgArea

MsgArea ASL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: American Sign Language Echo
        Tag         ASL
        Path        H:\Msg\Fido\A\asl
        Renum Max   200
End MsgArea

MsgArea ASP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Association of Shareware Profssls
        Tag         ASP
        Path        H:\Msg\Fido\A\asp
        Renum Max   100
End MsgArea

MsgArea ASTRONET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Astronet Echo
        Tag         ASTRONET
        Path        H:\Msg\Fido\A\Astronet
        Renum Max   300
End MsgArea

MsgArea ASTRONOM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Observational Astronomy Echo Conf.
        Tag         ASTRONOMY
        Path        H:\Msg\Fido\A\astronom
        Renum Max   100
End MsgArea

MsgArea ATHEISM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Intra-Atheist Education/Discussion
        Tag         ATHEISM
        Path        H:\Msg\Fido\A\atheism
        Renum Max   100
End MsgArea

MsgArea ATHEIST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: A_Theism Education & Enlightenment
        Tag         A_THEIST
        Path        H:\Msg\Fido\A\atheist
        Renum Max   100
End MsgArea

MsgArea ATNT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: AT&T PC Support Conference
        Tag         AT&T
        Path        H:\Msg\Fido\A\atnt
        Renum Max   100
End MsgArea

MsgArea AUDIO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International FidoNet Audio Echo
        Tag         AUDIO
        Path        H:\Msg\Fido\A\audio
        Renum Max   500
End MsgArea

MsgArea AUSGENEA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Australian Genealogy
        Tag         AUS_GENEALOGY
        Path        H:\Msg\Fido\A\Ausgenea
        Renum Max   500
End MsgArea

MsgArea AUTO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Automotive
        Tag         AUTOMOTIVE
        Path        H:\Msg\Fido\A\auto
        Renum Max   500
End MsgArea

MsgArea AUTORACE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Auto Racing Echo
        Tag         AUTORACE
        Path        H:\Msg\Fido\A\autorace
        Renum Max   100
End MsgArea

MsgArea AVIATION
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Aviation Echo
        Tag         AVIATION
        Path        H:\Msg\Fido\A\aviation
        Renum Max   100
End MsgArea

MsgArea AVICLTR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Captive Propagation of Birds
        Tag         AVICULTURE
        Path        H:\Msg\Fido\A\avicltr
        Renum Max   100
End MsgArea

msgdivisionend

msgdivisionbegin Fido-B Demoted DIVISION: FidoNet Areas B-BZ

MsgArea BABYLON5
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Babylon 5 Discussion
        Tag         BABYLON5
        Path        H:\Msg\Fido\B\babylon5
        Renum Max   300
End MsgArea

MsgArea BAHAI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bahai Faith
        Tag         BAHAI
        Path        H:\Msg\Fido\B\bahai
        Renum Max   300
End MsgArea

MsgArea BAMA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Odyssey Fringe Science Research Net
        Tag         BAMA
        Path        H:\Msg\Fido\B\bama
        Renum Max   1000
End MsgArea

MsgArea BARDROOM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: BardRoom Author's/Poets Get-together
        Tag         BARDROOM
        Path        H:\Msg\Fido\B\bardroom
        Renum Max   200
End MsgArea

MsgArea BASIC7
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PDS 7.x and VB/DOS Discussions
        Tag         BASIC7
        Path        H:\Msg\Fido\B\basic7
        Renum Max   1000
End MsgArea

MsgArea BASSGTR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bass Guitar Echo
        Tag         BASSGTR
        Path        H:\Msg\Fido\B\bassgtr
        Renum Max   100
End MsgArea

MsgArea BATPOWER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Batch Languages Programming
        Tag         BATPOWER
        Path        H:\Msg\Fido\B\batpower
        Renum Max   1000
End MsgArea

MsgArea BATTERED
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Family Violence
        Tag         BATTERED
        Path        H:\Msg\Fido\B\battered
        Renum Max   100
End MsgArea

MsgArea BBCARDS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Baseball Cards Conference
        Tag         BB-CARDS
        Path        H:\Msg\Fido\B\bbcards
        Renum Max   100
End MsgArea

MsgArea BBSADS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Advertise to Promote YOUR BBS!
        Tag         BBS_ADS
        Path        H:\Msg\Fido\B\bbsads
        Renum Max   500
End MsgArea

MsgArea BBSCARN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: BBS Software & Related Utility Chat
        Tag         BBS_CARNIVAL
        Path        H:\Msg\Fido\B\bbscarn
        Renum Max   500
End MsgArea

MsgArea BBSCON
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: BBS Conference
        Tag         BBSCON
        Path        H:\Msg\Fido\B\bbscon
        Renum Max   100
End MsgArea

MsgArea BBSDOORS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: BBS Door program Disc
        Tag         BBS_DOORS
        Path        H:\Msg\Fido\B\Bbsdoors
        Renum Max   300
End MsgArea

MsgArea BBSDRS2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: BBS Door program Disc
        Tag         BBSDOORS
        Path        H:\Msg\Fido\B\Bbsdrs2
        Renum Max   300
End MsgArea

MsgArea BBSLAW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bulletin Board Legal Issues Conf.
        Tag         BBSLAW
        Path        H:\Msg\Fido\B\bbslaw
        Renum Max   500
End MsgArea

MsgArea BBSLSTCO
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: BBS List Coordinators Disc.
        Tag         BBSLIST_CORD
        Path        H:\Msg\Fido\B\Bbslstco
        Renum Max   500
End MsgArea

MsgArea BBSSTNDR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: BBS Standards discussions
        Tag         BBS_STANDARDS
        Path        H:\Msg\Fido\B\Bbsstndr
        Renum Max   300
End MsgArea

MsgArea BEATLES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Beatles Echo
        Tag         BEATLES
        Path        H:\Msg\Fido\B\Beatles
        Renum Max   300
End MsgArea

MsgArea BFDSMAIL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Batch File Dist System Mail
        Tag         BFDS_MAIL
        Path        H:\Msg\Fido\B\Bfdsmail
        Renum Max   500
End MsgArea

MsgArea BGFAX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: BGFAX Support Echo
        Tag         BGFAX
        Path        H:\Msg\Fido\B\bgfax
        Renum Max   500
End MsgArea

MsgArea BH90210
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Beverly Hills 90210 conf
        Tag         BH90210
        Path        H:\Msg\Fido\B\Bh90210
        Renum Max   500
End MsgArea

MsgArea BIBLE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Bible Conference
        Tag         BIBLE
        Path        H:\Msg\Fido\B\bible
        Renum Max   300
End MsgArea

MsgArea BIBLESTD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bible Study Disc.
        Tag         BIBLE-STUDY
        Path        H:\Msg\Fido\B\biblestd
        Renum Max   200
End MsgArea

MsgArea BIGSMOKE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Big Smoke (?)
        Tag         BIG_SMOKE
        Path        H:\Msg\Fido\B\bigsmoke
        Renum Max   100
End MsgArea

MsgArea BIKNRIDR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bike and Rider
        Tag         BIKE-N-RIDER
        Path        H:\Msg\Fido\B\biknridr
        Renum Max   200
End MsgArea

MsgArea BIKENET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bicycling & Human Powered Vehicles
        Tag         BIKENET
        Path        H:\Msg\Fido\B\bikenet
        Renum Max   200
End MsgArea

MsgArea BINKLEY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Binkleyterm Mailer Echo
        Tag         BINKLEY
        Path        H:\Msg\Fido\B\binkley
        Renum Max   1000
End MsgArea

MsgArea BIOMED
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: BioMedical & Clinical Engineering
        Tag         BIOMED
        Path        H:\Msg\Fido\B\biomed
        Renum Max   100
End MsgArea

MsgArea BIRDING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Birding Echo
        Tag         BIRDING
        Path        H:\Msg\Fido\B\birding
        Renum Max   100
End MsgArea

MsgArea BIRTHMOT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Birth Mothers
        Tag         BIRTHMOTHERS
        Path        H:\Msg\Fido\B\birthmot
        Renum Max   100
End MsgArea

MsgArea BLKPOWDR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Black Powder Weapons
        Tag         BLACK_POWDER
        Path        H:\Msg\Fido\B\Blkpowdr
        Renum Max   300
End MsgArea

MsgArea BLINDTLK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Blind Talk
        Tag         BLINDTLK
        Path        H:\Msg\Fido\B\blindtlk
        Renum Max   200
End MsgArea

MsgArea BLNKTALK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Visual Disabilities Echo
        Tag         BLINKTALK
        Path        H:\Msg\Fido\B\blnktalk
        Renum Max   100
End MsgArea

MsgArea BLUEWAVE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Blue Wave Support Echo
        Tag         BLUEWAVE
        Path        H:\Msg\Fido\B\bluewave
        Renum Max   300
End MsgArea

MsgArea BNU
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: BNU FOSSIL Support Conference
        Tag         BNU
        Path        H:\Msg\Fido\B\bnu
        Renum Max   200
End MsgArea

MsgArea BOATING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Boating
        Tag         BOATING
        Path        H:\Msg\Fido\B\boating
        Renum Max   100
End MsgArea

MsgArea BODYWORK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bodywork & Massage Therapy Forum
        Tag         BODYWORK
        Path        H:\Msg\Fido\B\bodywork
        Renum Max   500
End MsgArea

MsgArea BOOKEM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bookem (?)
        Tag         BOOKEM
        Path        H:\Msg\Fido\B\bookem
        Renum Max   200
End MsgArea

MsgArea BRITCAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: British Car Echo
        Tag         BRIT_CAR
        Path        H:\Msg\Fido\B\britcar
        Renum Max   100
End MsgArea

MsgArea BRODCAST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Discussion of the Broadcasting
        Tag         BROADCAST
        Path        H:\Msg\Fido\B\brodcast
        Renum Max   100
End MsgArea

MsgArea BUSINESS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: The Business Conference
        Tag         BUSINESS
        Path        H:\Msg\Fido\B\Business
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-C Demoted DIVISION: FidoNet Areas C-CZ

MsgArea CABILITY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Canadian Ability
        Tag         C_ABILITY
        Path        H:\Msg\Fido\C\cability
        Renum Max   100
End MsgArea

MsgArea CADCAM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Computer Aided Design/Manufacturing
        Tag         CAD-CAM
        Path        H:\Msg\Fido\C\cadcam
        Renum Max   100
End MsgArea

MsgArea CADVOCAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Consumer Advocate
        Tag         C_ADVOCAT
        Path        H:\Msg\Fido\C\cadvocat
        Renum Max   500
End MsgArea

MsgArea CALLNY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Call New York
        Tag         CALLNY
        Path        H:\Msg\Fido\C\Callny
        Renum Max   500
End MsgArea

MsgArea CALLSIGN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Radio Callsign Disc.
        Tag         CALLSIGN
        Path        H:\Msg\Fido\C\Callsign
        Renum Max   500
End MsgArea

MsgArea CANFRCHT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Canadian Free Chat
        Tag         CAN_FREECHAT
        Path        H:\Msg\Fido\C\canfrcht
        Renum Max   200
End MsgArea

MsgArea CANMILIT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Canadian Military
        Tag         CAN_MILITARY
        Path        H:\Msg\Fido\C\canmilit
        Renum Max   200
End MsgArea

MsgArea CANSYSLW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Canadian Sysop Laws
        Tag         CAN_SYSLAW
        Path        H:\Msg\Fido\C\cansyslw
        Renum Max   200
End MsgArea

MsgArea CANCHAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Canadian Chat
        Tag         CANACHAT
        Path        H:\Msg\Fido\C\canchat
        Renum Max   200
End MsgArea

MsgArea CANPOL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Canadian Police
        Tag         CANPOL
        Path        H:\Msg\Fido\C\canpol
        Renum Max   200
End MsgArea

MsgArea CAPNAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CAP_NAT
        Tag         CAP_NAT
        Path        H:\Msg\Fido\C\capnat
        Renum Max   200
End MsgArea

MsgArea CARCINOM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Cancer Survivors
        Tag         CARCINOMA
        Path        H:\Msg\Fido\C\carcinom
        Renum Max   100
End MsgArea

MsgArea CARDIAC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Cardiac
        Tag         CARDIAC
        Path        H:\Msg\Fido\C\cardiac
        Renum Max   300
End MsgArea

MsgArea CAREGIVE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Care Giver
        Tag         CARE_GIVER
        Path        H:\Msg\Fido\C\caregive
        Renum Max   100
End MsgArea

MsgArea CAROLGEN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Carolina Genealogy
        Tag         CAROLINA_GEN
        Path        H:\Msg\Fido\C\carolgen
        Renum Max   200
End MsgArea

MsgArea CASINO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Casino's Discussions
        Tag         CASINO
        Path        H:\Msg\Fido\C\Casino
        Renum Max   500
End MsgArea

MsgArea CSNOGMBL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Casino Gambling Disc
        Tag         CASINO.GAMBLING
        Path        H:\Msg\Fido\C\Csnogmbl
        Renum Max   500
End MsgArea

MsgArea CB_RADIO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: General CB_RADIO Discussion MsgArea
        Tag         CB_RADIO
        Path        H:\Msg\Fido\C\cb_radio
        Renum Max   300
End MsgArea

MsgArea CBRADIO2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CB_RADIO_2 Discussion
        Tag         CB_RADIO_2
        Path        H:\Msg\Fido\C\cbradio2
        Renum Max   500
End MsgArea

MsgArea CBRAD4SL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CB_RADIOs 4 Sale
        Tag         CB_RADIO_4SALE
        Path        H:\Msg\Fido\C\cbrad4sl
        Renum Max   500
End MsgArea

MsgArea CBRDC4SL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CB_RADIOs C4Sale
        Tag         CB_RADIO_C4SALE
        Path        H:\Msg\Fido\C\cbrdc4sl
        Renum Max   500
End MsgArea

MsgArea CDECHO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The FidoNet CD Echo
        Tag         CD_ECHO
        Path        H:\Msg\Fido\C\cdecho
        Renum Max   500
End MsgArea

MsgArea CDOOR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RBBS/CDOR Support Echo
        Tag         CDOOR
        Path        H:\Msg\Fido\C\cdoor
        Renum Max   100
End MsgArea

MsgArea CDROM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CD-ROM Discussion & Information
        Tag         CDROM
        Path        H:\Msg\Fido\C\cdrom
        Renum Max   500
End MsgArea

MsgArea CDRSALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CD-ROM For Sale Echo
        Tag         CDROM_SALE
        Path        H:\Msg\Fido\C\cdrsale
        Renum Max   200
End MsgArea

MsgArea CECHO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The International C Echo
        Tag         C_ECHO
        Path        H:\Msg\Fido\C\cecho
        Renum Max   500
End MsgArea

MsgArea CELLULAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Cellular Telephone Discussion
        Tag         CELLULAR
        Path        H:\Msg\Fido\C\cellular
        Renum Max   100
End MsgArea

MsgArea CELLULR2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Cellular II Discussion
        Tag         CELLULAR_II
        Path        H:\Msg\Fido\C\Cellulr2
        Renum Max   500
End MsgArea

MsgArea CFL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CFL
        Tag         CFL
        Path        H:\Msg\Fido\C\cfl
        Renum Max   200
End MsgArea

MsgArea CFORSALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Commercial For Sale Echo
        Tag         CFORSALE
        Path        H:\Msg\Fido\C\cforsale
        Renum Max   200
End MsgArea

MsgArea CFS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Chronic Fatigue Syndrome
        Tag         CFS
        Path        H:\Msg\Fido\C\cfs
        Renum Max   200
End MsgArea

MsgArea CHANNELS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Channelled Msgs from Spirit Realms
        Tag         CHANNELS
        Path        H:\Msg\Fido\C\channels
        Renum Max   500
End MsgArea

MsgArea CHAOSLND
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Chaos-Landing
        Tag         CHAOS_LANDING
        Path        H:\Msg\Fido\C\chaoslnd
        Renum Max   500
End MsgArea

MsgArea CHATTER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Mindless Chatter Conf.
        Tag         CHATTER
        Path        H:\Msg\Fido\C\chatter
        Renum Max   500
End MsgArea

MsgArea CHESS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Fidonet Chess Conference
        Tag         CHESS
        Path        H:\Msg\Fido\C\chess
        Renum Max   100
End MsgArea

MsgArea CHESTRNY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Chess Tourney
        Tag         CHESS_TOURNEY
        Path        H:\Msg\Fido\C\chestrny
        Renum Max   200
End MsgArea

MsgArea CHICORA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: S.C. Genealogy 1670-1865
        Tag         CHICORA_GEN
        Path        H:\Msg\Fido\C\chicora
        Renum Max   500
End MsgArea

MsgArea CHLDABSE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Child Abuse Information & Recovery
        Tag         CHILD_ABUSE
        Path        H:\Msg\Fido\C\chldabse
        Renum Max   100
End MsgArea

MsgArea CHABISSU
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Child Abuse Issues
        Tag         CHILD_ABUSE_ISSUES
        Path        H:\Msg\Fido\C\chabissu
        Renum Max   300
End MsgArea

MsgArea CHAMELEO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Chameleon Program Disc
        Tag         CHAMELEON
        Path        H:\Msg\Fido\C\Chameleo
        Renum Max   500
End MsgArea

MsgArea CHIPSMAG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        Chips Magazine
        Tag         CHIPSMAG
        Path        H:\Msg\Fido\C\chipsmag
        Renum Max   500
End MsgArea

MsgArea CHRNPAIN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Chronic Pain
        Tag         CHRONIC_PAIN
        Path        H:\Msg\Fido\C\Chrnpain
        Renum Max   300
End MsgArea

MsgArea CHRCHST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sep/Church & State Disc
        Tag         CHURCH&STATE
        Path        H:\Msg\Fido\C\Chrchst
        Renum Max   500
End MsgArea

MsgArea CIVWAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Civil War Echo
        Tag         CIVIL_WAR
        Path        H:\Msg\Fido\C\civwar
        Renum Max   100
End MsgArea

MsgArea CIVLIB
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Civil Liberties Discussion
        Tag         CIVLIB
        Path        H:\Msg\Fido\C\civlib
        Renum Max   200
End MsgArea

MsgArea CLASSICL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Classical
        Tag         CLASSICAL
        Path        H:\Msg\Fido\C\classicl
        Renum Max   200
End MsgArea

MsgArea CLSIFDS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Classified Advertising Echo
        Tag         CLASSIFIEDS
        Path        H:\Msg\Fido\C\clsifds
        Renum Max   200
End MsgArea

MsgArea CMX4SALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Comics For Sale
        Tag         CMX4SALE
        Path        H:\Msg\Fido\C\cmx4sale
        Renum Max   100
End MsgArea

MsgArea COFKLAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Gossip and chit-chat Echo
        Tag         COFFEE_KLATSCH
        Path        H:\Msg\Fido\C\cofklat
        Renum Max   500
End MsgArea

MsgArea COINS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Coin/Token Collecting Discussion
        Tag         COINS
        Path        H:\Msg\Fido\C\coins
        Renum Max   100
End MsgArea

MsgArea COLLECT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Collectables
        Tag         COLLECTABLES
        Path        H:\Msg\Fido\C\collect
        Renum Max   100
End MsgArea

MsgArea COLLEGE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International College Echo
        Tag         COLLEGE
        Path        H:\Msg\Fido\C\college
        Renum Max   100
End MsgArea

MsgArea CLGSINGL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: College Singles Echo
        Tag         COLLEGE_SINGLES
        Path        H:\Msg\Fido\C\Clgsingl
        Renum Max   500
End MsgArea

MsgArea COMM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Communications Echo
        Tag         COMM
        Path        H:\Msg\Fido\C\comm
        Renum Max   300
End MsgArea

MsgArea COMICS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Comic Book Discussions Echo
        Tag         COMICS
        Path        H:\Msg\Fido\C\comics
        Renum Max   100
End MsgArea


MsgArea COMPRESS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Archiver & Compression Software
        Tag         COMPRESS
        Path        H:\Msg\Fido\C\compress
        Renum Max   500
End MsgArea

MsgArea COMPUSAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CompuSale Echo
        Tag         COMPUSALE
        Path        H:\Msg\Fido\C\compusal
        Renum Max   200
End MsgArea

MsgArea CONCORD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CONCORD Software Support MsgArea
        Tag         CONCORD
        Path        H:\Msg\Fido\C\concord
        Renum Max   100
End MsgArea

MsgArea CONFDHTG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Confederate Heritage
        Tag         CONFED_HERITAGE
        Path        H:\Msg\Fido\C\confdhtg
        Renum Max   300
End MsgArea

MsgArea CONSCIOU
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Consciousness Echo
        Tag         CONSCIOUSNESS
        Path        H:\Msg\Fido\C\Consciou
        Renum Max   500
End MsgArea

MsgArea CONSPRCY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Conspiracy Discussion
        Tag         CONSPRCY
        Path        H:\Msg\Fido\C\consprcy
        Renum Max   500
End MsgArea

MsgArea CONSTITU
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: General CONSTITUTIONAL
        Tag         CONSTITUTIONAL
        Path        H:\Msg\Fido\C\constitu
        Renum Max   300
End MsgArea

MsgArea CONSULTN
        ACS         Extra
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Consulting Forum
        Tag         CONSULTING
        Path        H:\Msg\Fido\C\consultn
        Renum Max   100
End MsgArea

MsgArea CONSRPT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Consumer Report
        Tag         CONSUMER_REPORT
        Path        H:\Msg\Fido\C\consrpt
        Renum Max   500
End MsgArea

MsgArea CONTROV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Controversial discussions
        Tag         CONTROV
        Path        H:\Msg\Fido\C\controv
        Renum Max   500
End MsgArea

MsgArea COOKING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National Cooking Echo
        Tag         COOKING
        Path        H:\Msg\Fido\C\cooking
        Renum Max   500
End MsgArea

MsgArea COOKSYSP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: COOK FDN Sysops
        Tag         COOKFDN-SYSOPS
        Path        H:\Msg\Fido\C\Cooksysp
        Renum Max   500
End MsgArea

MsgArea CORELDRW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Coreldraw echo
        Tag         CORELDRAW
        Path        H:\Msg\Fido\C\coreldrw
        Renum Max   200
End MsgArea

MsgArea COUNTRY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Country Music Discussion
        Tag         COUNTRY
        Path        H:\Msg\Fido\C\country
        Renum Max   100
End MsgArea

MsgArea CPALSY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Cerebral Palsy
        Tag         CPALSY
        Path        H:\Msg\Fido\C\cpalsy
        Renum Max   100
End MsgArea

MsgArea CPLUSP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Intnat'nl C++ Programming Conf.
        Tag         C_PLUSPLUS
        Path        H:\Msg\Fido\C\cplusp
        Renum Max   500
End MsgArea

MsgArea CRFTBAZR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Crafting Bazaars
        Tag         CRAFTING_BAZAAR
        Path        H:\Msg\Fido\C\Crftbazr
        Renum Max   500
End MsgArea

MsgArea CRAFTING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Handcrafts
        Tag         CRAFTING
        Path        H:\Msg\Fido\C\crafting
        Renum Max   300
End MsgArea

MsgArea CRAFT4SL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Crafting Projects & Supplies 4Sale
        Tag         CRAFTING-FORSALE
        Path        H:\Msg\Fido\C\craft4sl
        Renum Max   200
End MsgArea

MsgArea CREATART
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Creative Arts Disc.
        Tag         CREATIVE_ARTS
        Path        H:\Msg\Fido\C\Creatart
        Renum Max   500
End MsgArea

MsgArea CREDIT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: CREDIT
        Tag         CREDIT
        Path        H:\Msg\Fido\C\credit
        Renum Max   200
End MsgArea

MsgArea CRSSTCH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Cross Stitchers Conference
        Tag         CROSS_STITCH
        Path        H:\Msg\Fido\C\crsstch
        Renum Max   100
End MsgArea

MsgArea CUSS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Computer Users in the Social Sci
        Tag         CUSS
        Path        H:\Msg\Fido\C\cuss
        Renum Max   100
End MsgArea

MsgArea CWBATTLE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: CW Battles
        Tag         CW_BATTLES
        Path        H:\Msg\Fido\C\Cwbattle
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-D Demoted DIVISION: FidoNet Areas D-DZ

MsgArea DADS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Dads
        Tag         DADS
        Path        H:\Msg\Fido\D\dads
        Renum Max   300
End MsgArea

MsgArea DAIRYFRM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Dairy Farming
        Tag         DAIRY_FARM
        Path        H:\Msg\Fido\D\Dairyfrm
        Renum Max   500
End MsgArea

MsgArea DAPIE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: DAPIE ??????
        Tag         DAPIE
        Path        H:\Msg\Fido\D\Dapie
        Renum Max   500
End MsgArea

MsgArea DAWGSTAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: DAWG Star <??>
        Tag         DAWG*STAR
        Path        H:\Msg\Fido\D\Dawgstar
        Renum Max   500
End MsgArea

MsgArea DBASE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Database Topics, Techniques, Adv
        Tag         DBASE
        Path        H:\Msg\Fido\D\dbase
        Renum Max   100
End MsgArea

MsgArea DEBATE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DEBATE Conference
        Tag         DEBATE
        Path        H:\Msg\Fido\D\debate
        Renum Max   500
End MsgArea

MsgArea DELPHI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DELPHI Borland Delphi Programming
        Tag         DELPHI
        Path        H:\Msg\Fido\D\delphi
        Renum Max   200
End MsgArea

MsgArea DENTISTR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DENTISTRY
        Tag         DENTISTRY
        Path        H:\Msg\Fido\D\dentistr
        Renum Max   200
End MsgArea

MsgArea DESQVIEW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Desqview Tech Conference
        Tag         DESQVIEW
        Path        H:\Msg\Fido\D\desqview
        Renum Max   200
End MsgArea

MsgArea DIABETES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Diabetes Discussions and Support
        Tag         DIABETES
        Path        H:\Msg\Fido\D\diabetes
        Renum Max   100
End MsgArea

MsgArea DIETING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Dieting
        Tag         DIETING
        Path        H:\Msg\Fido\D\dieting
        Renum Max   100
End MsgArea

MsgArea DISASTER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Disaster Info/Relief/Recovery
        Tag         DISASTERS
        Path        H:\Msg\Fido\D\disaster
        Renum Max   100
End MsgArea

MsgArea DISNEY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Disney Discussions
        Tag         DISNEY
        Path        H:\Msg\Fido\D\disney
        Renum Max   100
End MsgArea

MsgArea DLGNFO
        ACS         Extra
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DLG Professional Information
        Tag         DLG_INFO
        Path        H:\Msg\Fido\D\dlgnfo
        Renum Max   100
End MsgArea

MsgArea DLGSUPP
        ACS         Extra
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DLG Support Echo
        Tag         DLG_SUPPORT
        Path        H:\Msg\Fido\D\dlgsupp
        Renum Max   100
End MsgArea

MsgArea DND
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Dungeons & Dragons Discussion
        Tag         DND
        Path        H:\Msg\Fido\D\dnd
        Renum Max   100
End MsgArea

MsgArea DOGFANCY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DOG_FANCIERS Conference
        Tag         DOG_FANCIERS
        Path        H:\Msg\Fido\D\dogfancy
        Renum Max   100
End MsgArea

MsgArea DOGHOUSE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DOGHOUSE Echo
        Tag         DOGHOUSE
        Path        H:\Msg\Fido\D\doghouse
        Renum Max   100
End MsgArea

MsgArea DOMINO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RISC BBS (Remote Imaging SysCtrl)
        Tag         DOMINO
        Path        H:\Msg\Fido\D\domino
        Renum Max   100
End MsgArea

MsgArea DOOM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DOOM/Id Software Support Echo
        Tag         DOOM
        Path        H:\Msg\Fido\D\doom
        Renum Max   500
End MsgArea

MsgArea DOORGAME
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: BBS Doorgames & Discussions
        Tag         DOORGAMES
        Path        H:\Msg\Fido\D\doorgame
        Renum Max   500
End MsgArea

MsgArea DOORWARE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: DOORWARE (tm) Support Echo & Gen
        Tag         DOORWARE
        Path        H:\Msg\Fido\D\doorware
        Renum Max   100
End MsgArea

MsgArea DOS-INET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: DOS Internet Etc.
        Tag         DOS_INTERNET
        Path        H:\Msg\Fido\D\Dos-inet
        Renum Max   300
End MsgArea

MsgArea DRDEBUG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Doctor Debug's Laboratory
        Tag         DR_DEBUG
        Path        H:\Msg\Fido\D\drdebug
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-E Demoted DIVISION: FidoNet Areas E-EZ

MsgArea ECSUPPRT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: EzyCom Support Echo
        Tag         EC_SUPPORT
        Path        H:\Msg\Fido\E\ecsupprt
        Renum Max   100
End MsgArea

MsgArea ECHOADS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Echo ADs
        Tag         ECHO_ADS
        Path        H:\Msg\Fido\E\echoads
        Renum Max   200
End MsgArea

MsgArea ECHOLIST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Echolist access conference
        Tag         ECHOLIST
        Path        H:\Msg\Fido\E\echolist
        Renum Max   100
End MsgArea

MsgArea ECHOREQ
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Echo Requests
        Tag         ECHO_REQ
        Path        H:\Msg\Fido\E\echo_req
        Renum Max   100
End MsgArea

MsgArea ECHOREVW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Echo Reviews
        Tag         ECHOREVIEWS
        Path        H:\Msg\Fido\E\echorevw
        Renum Max   500
End MsgArea

MsgArea ECOLOGY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Ecology Problems & Potential Sol
        Tag         ECOLOGY
        Path        H:\Msg\Fido\E\ecology
        Renum Max   100
End MsgArea

MsgArea ECPROG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: East Coast Programmer's Echo
        Tag         ECPROG
        Path        H:\Msg\Fido\E\ecprog
        Renum Max   100
End MsgArea

MsgArea ECSTASY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Ecstasy
        Tag         ECSTASY
        Path        H:\Msg\Fido\E\ecstasy
        Renum Max   100
End MsgArea

MsgArea EDUCATOR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: EDUCATOR
        Tag         EDUCATOR
        Path        H:\Msg\Fido\E\educator
        Renum Max   100
End MsgArea

MsgArea ELECTRNC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Home Electronics & Appliances
        Tag         ELECTRONICS
        Path        H:\Msg\Fido\E\electrnc
        Renum Max   500
End MsgArea

MsgArea EMBEDDED
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Embedded Systems Prog & Engnrng
        Tag         EMBEDDED
        Path        H:\Msg\Fido\E\embedded
        Renum Max   100
End MsgArea

MsgArea EMS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Emergency Medical Services
        Tag         EMS
        Path        H:\Msg\Fido\E\ems
        Renum Max   100
End MsgArea

MsgArea ENTRPRNR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Entrepreneur Conference
        Tag         ENTREPRENEUR
        Path        H:\Msg\Fido\E\entrprnr
        Renum Max   500
End MsgArea

MsgArea ENVIRO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Environmental Concerns
        Tag         ENVIRO
        Path        H:\Msg\Fido\E\enviro
        Renum Max   100
End MsgArea

MsgArea ENVIRON
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Environmental Issues
        Tag         ENVIRON
        Path        H:\Msg\Fido\E\environ
        Renum Max   100
End MsgArea

MsgArea EPANNCE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: EP Announcements
        Tag         EP-ANNOUNCE
        Path        H:\Msg\Fido\E\Epannce
        Renum Max   500
End MsgArea

MsgArea EP-GENRL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Electronic Pub. General
        Tag         EP-GENERAL
        Path        H:\Msg\Fido\E\Ep-genrl
        Renum Max   500
End MsgArea

MsgArea EP-PBLSH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Electonic Pub. Publishing
        Tag         EP-PUBLISH
        Path        H:\Msg\Fido\E\Ep-pblsh
        Renum Max   500
End MsgArea

MsgArea EPSYSOP
        ACS         Clerk
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: EP Sysops Echo
        Tag         EP-SYSOP
        Path        H:\Msg\Fido\E\Epsysop
        Renum Max   500
End MsgArea

MsgArea EQUUS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Horse Discussion Echo
        Tag         EQUUS
        Path        H:\Msg\Fido\E\equus
        Renum Max   100
End MsgArea

MsgArea ER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ER Discussions Conf.
        Tag         ER
        Path        H:\Msg\Fido\E\Er
        Renum Max   500
End MsgArea

MsgArea ESPERNTO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Esperanto Language Echo
        Tag         ESPERANTO
        Path        H:\Msg\Fido\E\Espernto
        Renum Max   500
End MsgArea

MsgArea ESPRIT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Esprit (?)
        Tag         ESPRIT
        Path        H:\Msg\Fido\E\Esprit
        Renum Max   300
End MsgArea

MsgArea EVOLUTIO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Evolution Mechanism Theory Disc
        Tag         EVOLUTION
        Path        H:\Msg\Fido\E\evolutio
        Renum Max   100
End MsgArea

msgdivisionend

msgdivisionbegin Fido-F Demoted DIVISION: FidoNet Areas F-FZ

MsgArea FALCNCBC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Falcon's Eye Disc.
        Tag         FALCON_CBCS
        Path        I:\Msg2\Fido\F\falcncbc
        Renum Max   500
End MsgArea

MsgArea FANTSPRT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Fantasy Sports Software Disc.
        Tag         FANTASY_SPORTS
        Path        I:\Msg2\Fido\F\fantsprt
        Renum Max   500
End MsgArea

MsgArea FARMING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Farming Discussions
        Tag         FARMING
        Path        I:\Msg2\Fido\F\farming
        Renum Max   500
End MsgArea

MsgArea FCC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Radio & Data Telecomm Regulations
        Tag         FCC
        Path        I:\Msg2\Fido\F\fcc
        Renum Max   300
End MsgArea

MsgArea FEHELP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FastEcho EchoMail tosser Help&Sup
        Tag         FE_HELP
        Path        I:\Msg2\Fido\F\fehelp
        Renum Max   500
End MsgArea

MsgArea FEMINISM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Feminism & Gender Issues
        Tag         FEMINISM
        Path        I:\Msg2\Fido\F\feminism
        Renum Max   100
End MsgArea

MsgArea FENCPOST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Fence Post (?) Discussion
        Tag         FENCE_POST
        Path        I:\Msg2\Fido\F\Fencpost
        Renum Max   500
End MsgArea

MsgArea FERNWOS2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FernWood OS/2 New file rep
        Tag         FERNWOS2
        Path        I:\Msg2\Fido\F\Fernwos2
        Renum Max   500
End MsgArea

MsgArea FIBROM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Fibromyalgia/Fibrositis Disc
        Tag         FIBROM
        Path        I:\Msg2\Fido\F\fibrom
        Renum Max   100
End MsgArea

MsgArea FIDOBBS
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FIDO BBS Software, Supp, Topics
        Tag         FIDOBBS
        Path        I:\Msg2\Fido\F\fidobbs
        Renum Max   500
End MsgArea

MsgArea FIDOBILL
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: FIDOBILL
        Tag         FIDOBILL
        Path        I:\Msg2\Fido\F\Fidobill
        Renum Max   500
End MsgArea

MsgArea FILEFIND
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FileFind Echo for use w/ALLFIX
        Tag         FILEFIND
        Path        I:\Msg2\Fido\F\filefind
        Renum Max   500
End MsgArea

MsgArea FILEGATE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Filegate project Echo
        Tag         FILEGATE
        Path        I:\Msg2\Fido\F\Filegate
        Renum Max   500
End MsgArea

MsgArea FILEMOVE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: File Movers Echo
        Tag         FILE_MOVERS
        Path        I:\Msg2\Fido\F\Filemove
        Renum Max   500
End MsgArea

MsgArea FILE_REQ
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: File Dist. Networks, Info, Etc.
        Tag         FILE_REQ
        Path        I:\Msg2\Fido\F\filereq
        Renum Max   500
End MsgArea

MsgArea FILK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Science Fiction Fannish Folksongs
        Tag         FILK
        Path        I:\Msg2\Fido\F\filk
        Renum Max   500
End MsgArea

MsgArea FILM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Film and movies
        Tag         FILM
        Path        I:\Msg2\Fido\F\Film
        Renum Max   300
End MsgArea

MsgArea FIREARMS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Firearms (NO POLITICS) Technical
        Tag         FIREARMS
        Path        I:\Msg2\Fido\F\firearms
        Renum Max   500
End MsgArea

MsgArea FIRENET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Firefighters Echo
        Tag         FIRENET
        Path        I:\Msg2\Fido\F\firenet
        Renum Max   100
End MsgArea

MsgArea FISHING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Fishing discussions of all kinds
        Tag         FISHING
        Path        I:\Msg2\Fido\F\fishing
        Renum Max   100
End MsgArea

MsgArea FITNESS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Fitness Discussion
        Tag         FITNESS
        Path        I:\Msg2\Fido\F\Fitness
        Renum Max   500
End MsgArea

MsgArea FKNIGHT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The FOREVER KNIGHT Echo
        Tag         F_KNIGHT
        Path        I:\Msg2\Fido\F\fknight
        Renum Max   100
End MsgArea

MsgArea FLAME
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The National FLAME Echo
        Tag         FLAME
        Path        I:\Msg2\Fido\F\flame
        Renum Max   100
End MsgArea

MsgArea FLATTAX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Flat Tax Discussion
        Tag         FLAT_TAX
        Path        I:\Msg2\Fido\F\flattax
        Renum Max   200
End MsgArea

MsgArea FLYING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Flying
        Tag         FLYING
        Path        I:\Msg2\Fido\F\flying
        Renum Max   300
End MsgArea

MsgArea FMS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FMS
        Tag         FMS
        Path        I:\Msg2\Fido\F\fms
        Renum Max   200
End MsgArea

MsgArea FNSYSOP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Sysop International Echo
        Tag         FN_SYSOP
        Path        I:\Msg2\Fido\F\fnsysop
        Renum Max   200
End MsgArea

MsgArea FOR-SALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National For Sale Echo
        Tag         FOR-SALE
        Path        I:\Msg2\Fido\F\for-sale
        Renum Max   200
End MsgArea

MsgArea FOSTER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FOSTER PARENTS/CHILDREN
        Tag         FOSTER
        Path        I:\Msg2\Fido\F\foster
        Renum Max   300
End MsgArea

MsgArea FOXPRO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FoxPro & Fox Database Products
        Tag         FOXPRO
        Path        I:\Msg2\Fido\F\foxpro
        Renum Max   100
End MsgArea

MsgArea FREEBIBL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Free Bible
        Tag         FREE_BIBLE
        Path        I:\Msg2\Fido\F\Freebibl
        Renum Max   500
End MsgArea

MsgArea FREESPCH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Free Speech
        Tag         FREE_SPEECH
        Path        I:\Msg2\Fido\F\freespch
        Renum Max   300
End MsgArea

MsgArea FREEMAIL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FreeMail and Alexi/Ware Support
        Tag         FREEMAIL
        Path        I:\Msg2\Fido\F\freemail
        Renum Max   100
End MsgArea

MsgArea FREEMASN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FreeMasonry
        Tag         FREEMASON
        Path        I:\Msg2\Fido\F\freemasn
        Renum Max   200
End MsgArea

MsgArea FS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Flight Simulators
        Tag         FS
        Path        I:\Msg2\Fido\F\fs
        Renum Max   200
End MsgArea

MsgArea FTPFIDO
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FTP for Fido
        Tag         FTP_FIDO
        Path        I:\Msg2\Fido\F\ftpfido
        Renum Max   200
End MsgArea

MsgArea FUNNY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Funny Jokes & Stories
        Tag         FUNNY
        Path        I:\Msg2\Fido\F\funny
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-G Demoted DIVISION: FidoNet Areas G-GZ

MsgArea GAMEDEV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Game Development Disc.
        Tag         GAMEDEV
        Path        I:\Msg2\Fido\G\Gamedev
        Renum Max   500
End MsgArea

MsgArea GAMING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Intrnat'l Personal Computer Gam
        Tag         GAMING
        Path        I:\Msg2\Fido\G\gaming
        Renum Max   200
End MsgArea

MsgArea GENDATA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Tiny Tafel Database
        Tag         GENDATA
        Path        I:\Msg2\Fido\G\gendata
        Renum Max   200
End MsgArea

MsgArea GENDER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Gender
        Tag         GENDER
        Path        I:\Msg2\Fido\G\gender
        Renum Max   200
End MsgArea

MsgArea GEN4SALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: General For Sale Echo
        Tag         GEN4SALE
        Path        I:\Msg2\Fido\G\Gen4sale
        Renum Max   500
End MsgArea

MsgArea GENEALOG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National Geanealogical Conf
        Tag         GENEALOGY
        Path        I:\Msg2\Fido\G\genealog
        Renum Max   500
End MsgArea

MsgArea GENE_CDN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Canadian Geanealogical Echo
        Tag         GENEALOGY.CDN
        Path        I:\Msg2\Fido\G\gene_cdn
        Renum Max   500
End MsgArea

MsgArea GENE_EUR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Genealogy & Family History
        Tag         GENEALOGY.EUR
        Path        I:\Msg2\Fido\G\gene_eur
        Renum Max   500
End MsgArea

MsgArea GENREPLY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Tiny Tafel Reply
        Tag         GENREPLY
        Path        I:\Msg2\Fido\G\genreply
        Renum Max   500
End MsgArea

MsgArea GENSOFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Genealogy Software Echo
        Tag         GENSOFT
        Path        I:\Msg2\Fido\G\gensoft
        Renum Max   500
End MsgArea

MsgArea GENSYSOP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Genealogy Sysop Echo
        Tag         GENSYSOP
        Path        I:\Msg2\Fido\G\gensysop
        Renum Max   500
End MsgArea

MsgArea GIGO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: GIGO Mail gateway
        Tag         GIGO
        Path        I:\Msg2\Fido\G\Gigo
        Renum Max   500
End MsgArea

MsgArea GOLDED
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: GoldED Mail Editor Support
        Tag         GOLDED
        Path        I:\Msg2\Fido\G\golded
        Renum Max   200
End MsgArea

MsgArea GOLDEDBT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: GoldEd Beta Echo
        Tag         GOLDED.BETA
        Path        I:\Msg2\Fido\G\Goldedbt
        Renum Max   500
End MsgArea

MsgArea GOPPOLIT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: GOP Political echo
        Tag         GOP_POLITICS
        Path        I:\Msg2\Fido\G\goppolit
        Renum Max   200
End MsgArea

MsgArea GOURMET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Gourmet Cooking
        Tag         GOURMET
        Path        I:\Msg2\Fido\G\gourmet
        Renum Max   300
End MsgArea

MsgArea GRAPHICS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Graphics
        Tag         GRAPHICS
        Path        I:\Msg2\Fido\G\graphics
        Renum Max   100
End MsgArea

MsgArea GRASSRTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Grassroots Discussion
        Tag         GRASSROOTS
        Path        I:\Msg2\Fido\G\Grassrts
        Renum Max   300
End MsgArea

MsgArea GRNDRNDS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Grand Rounds Medical
        Tag         GRAND_ROUNDS
        Path        I:\Msg2\Fido\G\Grndrnds
        Renum Max   300
End MsgArea

MsgArea GREEN029
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: "The" International EnviroConf.
        Tag         GREEN.029
        Path        I:\Msg2\Fido\G\green029
        Renum Max   100
End MsgArea

MsgArea GT-ANSI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: GT Ansi Disc.
        Tag         GT_ANSI
        Path        I:\Msg2\Fido\G\Gt-ansi
        Renum Max   500
End MsgArea

MsgArea GUITAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Guitar Topics & Ovation Abuse
        Tag         GUITAR
        Path        I:\Msg2\Fido\G\guitar
        Renum Max   100
End MsgArea

MsgArea GUNCNTRL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Gun Control Discussion
        Tag         GUN_CONTROL
        Path        I:\Msg2\Fido\G\Guncntrl
        Renum Max   500
End MsgArea

MsgArea GUNS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Guns & Defence Weaponry
        Tag         GUNS
        Path        I:\Msg2\Fido\G\guns
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-H Demoted DIVISION: FidoNet Areas H-HZ

MsgArea HAM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Amateur Radio Interest
        Tag         HAM
        Path        I:\Msg2\Fido\H\ham
        Renum Max   500
End MsgArea

MsgArea HAMREQ
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Amateur Radio File Announcemen
        Tag         HAM_REQ
        Path        I:\Msg2\Fido\H\hamreq
        Renum Max   500
End MsgArea

MsgArea HAMTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: HAM (Amateur) Radio Technology
        Tag         HAM_TECH
        Path        I:\Msg2\Fido\H\hamtech
        Renum Max   500
End MsgArea

MsgArea HAMSALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: HAM equip for sale
        Tag         HAM-SALE
        Path        I:\Msg2\Fido\H\hamsale
        Renum Max   500
End MsgArea

MsgArea HARDAV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Harley Davidson Motorcycles
        Tag         HARLEY_DAVIDSON
        Path        I:\Msg2\Fido\H\hardav
        Renum Max   500
End MsgArea

MsgArea HAYES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Hayes Modems Conference
        Tag         HAYES
        Path        I:\Msg2\Fido\H\hayes
        Renum Max   500
End MsgArea

MsgArea HDCONF
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: The Hard Drive Conference
        Tag         HDCONF
        Path        I:\Msg2\Fido\H\Hdconf
        Renum Max   300
End MsgArea

MsgArea HDSALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Hard Drive Sale Echo
        Tag         HDSALE
        Path        I:\Msg2\Fido\H\Hdsale
        Renum Max   300
End MsgArea

MsgArea HERBSUCH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Herbs, etc
        Tag         HERBS-N-SUCH
        Path        I:\Msg2\Fido\H\Herbsuch
        Renum Max   300
End MsgArea

MsgArea HOBBIES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Hobbies General Disc.
        Tag         HOBBIES
        Path        I:\Msg2\Fido\H\Hobbies
        Renum Max   500
End MsgArea

MsgArea HERMESSY
        ACS         Asstsysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Hermes Sysops
        Tag         HERMES_SYSOPS
        Path        I:\Msg2\Fido\H\Hermessy
        Renum Max   500
End MsgArea

MsgArea HLPMNKND
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Help Mankind
        Tag         HELP_MANKIND
        Path        I:\Msg2\Fido\H\Hlpmnknd
        Renum Max   500
End MsgArea

MsgArea HIGHLNDR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Highlander Discussion
        Tag         HIGHLANDER
        Path        I:\Msg2\Fido\H\Highlndr
        Renum Max   500
End MsgArea

MsgArea HISTORY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Discussions on History
        Tag         HISTORY
        Path        I:\Msg2\Fido\H\History
        Renum Max   300
End MsgArea

MsgArea HOCKEY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Hockey Fans Echo
        Tag         HOCKEY
        Path        I:\Msg2\Fido\H\Hockey
        Renum Max   300
End MsgArea

MsgArea HCKYCARD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Hockey Card Collectors
        Tag         HOCKEY_CARDS
        Path        I:\Msg2\Fido\H\Hckycard
        Renum Max   500
End MsgArea

MsgArea HOLISTIC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Holistic Healing
        Tag         HOLISTIC
        Path        I:\Msg2\Fido\H\Holistic
        Renum Max   500
End MsgArea

MsgArea HOLYBIBL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Holy Bible Conf
        Tag         HOLY_BIBLE
        Path        I:\Msg2\Fido\H\Holybibl
        Renum Max   500
End MsgArea

MsgArea HOLYBIFC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Holy Bible FCS (?)
        Tag         HOLY_BIBLE_FCS
        Path        I:\Msg2\Fido\H\holybifc
        Renum Max   200
End MsgArea

MsgArea HOLYSMOK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: HolySmoke echo
        Tag         HOLYSMOKE
        Path        I:\Msg2\Fido\H\Holysmok
        Renum Max   300
End MsgArea

MsgArea HOMEAUTO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Home Automation & Security
        Tag         HOME_AUTOMATION
        Path        I:\Msg2\Fido\H\homeauto
        Renum Max   500
End MsgArea

MsgArea HOMECOOK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Home Cooking & Related Topics
        Tag         HOME_COOKING
        Path        I:\Msg2\Fido\H\homecook
        Renum Max   500
End MsgArea

MsgArea HOMEGRDN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The Home & Garden Echo
        Tag         HOME-N-GRDN
        Path        I:\Msg2\Fido\H\homegrdn
        Renum Max   500
End MsgArea

MsgArea HOMEPOWR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Alternative Energy Systems,etc
        Tag         HOMEPOWR
        Path        I:\Msg2\Fido\H\homepowr
        Renum Max   500
End MsgArea

MsgArea HOMESCHL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Home Schooling Support
        Tag         HOMESCHL
        Path        I:\Msg2\Fido\H\homeschl
        Renum Max   500
End MsgArea

MsgArea HP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Hewlett-Packard Discussions
        Tag         HP
        Path        I:\Msg2\Fido\H\hp
        Renum Max   500
End MsgArea

MsgArea HSMODEMS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: High Speed Modems Disc.
        Tag         HS_MODEMS
        Path        I:\Msg2\Fido\H\hsmodems
        Renum Max   500
End MsgArea

MsgArea HTMLEDIT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: HTML Editing Discussion
        Tag         HTMLEDIT
        Path        I:\Msg2\Fido\H\htmledit
        Renum Max   500
End MsgArea

MsgArea HUMOR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Joker's Korner, Read/Only Conf
        Tag         HUMOR
        Path        I:\Msg2\Fido\H\humor
        Renum Max   500
End MsgArea

MsgArea HYPER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Hyper ???
        Tag         HYPER
        Path        I:\Msg2\Fido\H\Hyper
        Renum Max   500
End MsgArea

MsgArea HYPERWRE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Hyperware Hyperdisk Technical
        Tag         HYPERWARE
        Path        I:\Msg2\Fido\H\hyperwre
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-I Demoted DIVISION: FidoNet Areas I-IZ

MsgArea I95
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Interstate 95 MsgArea BBS Chat
        Tag         I95
        Path        I:\Msg2\Fido\I\i95
        Renum Max   500
End MsgArea

MsgArea ICGAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ICGAL
        Tag         ICGAL
        Path        I:\Msg2\Fido\I\icgal
        Renum Max   200
End MsgArea

MsgArea ICOM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ICOM
        Tag         ICOM
        Path        I:\Msg2\Fido\I\icom
        Renum Max   200
End MsgArea

MsgArea IEEE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Institute of Electrical & Elec
        Tag         IEEE
        Path        I:\Msg2\Fido\I\ieee
        Renum Max   500
End MsgArea

MsgArea INCNTRY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Combat Veteran's Echo
        Tag         IN_COUNTRY
        Path        I:\Msg2\Fido\I\incntry
        Renum Max   500
End MsgArea

MsgArea INDAFF
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Indian Affairs
        Tag         INDIAN_AFFAIRS
        Path        I:\Msg2\Fido\I\indaff
        Renum Max   500
End MsgArea

MsgArea INTRCOOK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Cooking
        Tag         INTERCOOK
        Path        I:\Msg2\Fido\I\intrcook
        Renum Max   500
End MsgArea

MsgArea INTERNET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Internet Disc. From Users View
        Tag         INTERNET
        Path        I:\Msg2\Fido\I\internet
        Renum Max   1000
End MsgArea

MsgArea INK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: INK
        Tag         INK
        Path        I:\Msg2\Fido\I\ink
        Renum Max   200
End MsgArea

MsgArea INTLGROW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Intelligent Growing Echo
        Tag         INTELLIGENT_GROWING
        Path        I:\Msg2\Fido\I\Intlgrow
        Renum Max   500
End MsgArea

MsgArea INTLMODM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Intel Modems
        Tag         INTEL_MODEMS
        Path        I:\Msg2\Fido\I\intlmodm
        Renum Max   200
End MsgArea

MsgArea INTRFAIT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Inter Faith
        Tag         INTERFAITH
        Path        I:\Msg2\Fido\I\intrfait
        Renum Max   200
End MsgArea

MsgArea INTERUSR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Genr'l Conversat
        Tag         INTERUSER
        Path        I:\Msg2\Fido\I\interusr
        Renum Max   500
End MsgArea

MsgArea INTRPAIN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Intractable Pain disc
        Tag         INTRACTABLE_PAIN
        Path        I:\Msg2\Fido\I\Intrpain
        Renum Max   300
End MsgArea

MsgArea INVEST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Investor's Forum
        Tag         INVEST
        Path        I:\Msg2\Fido\I\invest
        Renum Max   500
End MsgArea

MsgArea IRONOX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: IRONOX & Other Doorgames
        Tag         IRONOX
        Path        I:\Msg2\Fido\I\ironox
        Renum Max   500
End MsgArea

MsgArea ISDN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Integrated Systems Digital Net
        Tag         ISDN
        Path        I:\Msg2\Fido\I\isdn
        Renum Max   500
End MsgArea

MsgArea ITALGEN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Italiano Genealogy
        Tag         ITALIANO.GEN
        Path        I:\Msg2\Fido\I\italgen
        Renum Max   200
End MsgArea

MsgArea IUFO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Open UFO Discussion & New Sci
        Tag         I_UFO
        Path        I:\Msg2\Fido\I\iufo
        Renum Max   1000
End MsgArea

msgdivisionend

msgdivisionbegin Fido-J Demoted DIVISION: FidoNet Areas J-JZ

MsgArea JAZZ
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: JAZZ
        Tag         JAZZ
        Path        I:\Msg2\Fido\J\jazz
        Renum Max   100
End MsgArea

MsgArea JEWISHGN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Jewish Genealogy Conference
        Tag         JEWISHGEN
        Path        I:\Msg2\Fido\J\jewishgn
        Renum Max   300
End MsgArea

MsgArea JFKASSN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: John F. Kennedy Assassination
        Tag         JFK_ASSN
        Path        I:\Msg2\Fido\J\jfkassn
        Renum Max   300
End MsgArea

MsgArea JOBS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: JOBS Echo
        Tag         JOBS
        Path        I:\Msg2\Fido\J\Jobs
        Renum Max   500
End MsgArea

MsgArea JOBS-NOW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: JOBS NOW!!
        Tag         JOBS-NOW
        Path        I:\Msg2\Fido\J\Jobs-now
        Renum Max   500
End MsgArea

MsgArea JOURNAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pioneer Journal Entries
        Tag         JOURNAL
        Path        I:\Msg2\Fido\J\journal
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-K Demoted DIVISION: FidoNet Areas K-KZ

MsgArea K9COPS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Conference on Police Dogs
        Tag         K9COPS
        Path        I:\Msg2\Fido\K\k9cops
        Renum Max   100
End MsgArea

MsgArea KAG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: KAG (Not a clue folks!)
        Tag         KAG
        Path        I:\Msg2\Fido\K\kag
        Renum Max   100
End MsgArea

MsgArea KATTYK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Cat Conference
        Tag         KATTY_KORNER
        Path        I:\Msg2\Fido\K\kattyk
        Renum Max   100
End MsgArea

MsgArea KCEMAIL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: KCE Mail
        Tag         KCEMAIL
        Path        I:\Msg2\Fido\K\kcemail
        Renum Max   300
End MsgArea

MsgArea KIDS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International KIDS Conference
        Tag         KIDS
        Path        I:\Msg2\Fido\K\kids
        Renum Max   100
End MsgArea

MsgArea KLAW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: K.L.A.W. ???? (what the)
        Tag         K.L.A.W.
        Path        I:\Msg2\Fido\K\Klaw
        Renum Max   500
End MsgArea

MsgArea KLINGON
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Star Trek Klingon Discussions
        Tag         KLINGON
        Path        I:\Msg2\Fido\K\klingon
        Renum Max   300
End MsgArea

MsgArea KLNGNRPG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Klingon RPG Conf
        Tag         KLINGON_RPG
        Path        I:\Msg2\Fido\K\Klngnrpg
        Renum Max   500
End MsgArea

MsgArea KOMBUCHA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Kombucha <?>
        Tag         KOMBUCHA
        Path        I:\Msg2\Fido\K\Kombucha
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-L Demoted DIVISION: FidoNet Areas L-LZ

MsgArea LAN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Local MsgArea Networks
        Tag         LAN
        Path        I:\Msg2\Fido\L\lan
        Renum Max   300
End MsgArea

MsgArea LAND
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Land of Devastation Doorgame
        Tag         LAND
        Path        I:\Msg2\Fido\L\land
        Renum Max   300
End MsgArea

MsgArea LANNET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: LAN & NET Discussion
        Tag         LANNET
        Path        I:\Msg2\Fido\L\Lannet
        Renum Max   500
End MsgArea

MsgArea LANTASTI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Artisoft LANtastic Support Con
        Tag         LANTASTI
        Path        I:\Msg2\Fido\L\lantasti
        Renum Max   300
End MsgArea

MsgArea LASERPUB
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Laser Publishing
        Tag         LASERPUB
        Path        I:\Msg2\Fido\L\laserpub
        Renum Max   300
End MsgArea

MsgArea LAW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: LEGAL ISSUES CONFERENCE
        Tag         LAW
        Path        I:\Msg2\Fido\L\law
        Renum Max   300
End MsgArea

MsgArea LAWNORDR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Law Enforcement Issues
        Tag         LAW_&_ORDER
        Path        I:\Msg2\Fido\L\lawnordr
        Renum Max   300
End MsgArea

MsgArea LAWNDIS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: "Law & Disorder" Discussion
        Tag         LAW_DISORDER
        Path        I:\Msg2\Fido\L\lawndis
        Renum Max   300
End MsgArea

MsgArea LAWNFRDM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Law & Freedom
        Tag         LAW_&_FREEDOM
        Path        I:\Msg2\Fido\L\Lawnfrdm
        Renum Max   500
End MsgArea

MsgArea LAWTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Law & Technology
        Tag         LAW_TECH
        Path        I:\Msg2\Fido\L\lawtech
        Renum Max   300
End MsgArea

MsgArea LEGLAW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: LEGAL_LAW Conference
        Tag         LEGAL_LAW
        Path        I:\Msg2\Fido\L\leglaw
        Renum Max   300
End MsgArea

MsgArea LIBRARY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Information Power!
        Tag         LIBRARY
        Path        I:\Msg2\Fido\L\library
        Renum Max   300
End MsgArea

MsgArea LINUX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Linux Operating System(Fido)
        Tag         LINUX
        Path        I:\Msg2\Fido\L\linux
        Renum Max   300
End MsgArea

MsgArea LOCMUS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Local Music
        Tag         LOCAL_MUSIC
        Path        I:\Msg2\Fido\L\locmus
        Renum Max   300
End MsgArea

MsgArea LORD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: L.O.R.D. Red Dragon Gaming
        Tag         LORD
        Path        I:\Msg2\Fido\L\lord
        Renum Max   200
End MsgArea

MsgArea LORDSYSP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: L.O.R.D. Red Dragon Sysop
        Tag         LORD
        Path        I:\Msg2\Fido\L\lordsysp
        Renum Max   300
End MsgArea

MsgArea LORE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: LORE
        Tag         LORE
        Path        I:\Msg2\Fido\L\lore
        Renum Max   500
End MsgArea

MsgArea LOTKIDS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Lots of Kids/Large Family
        Tag         LOTAKIDS
        Path        I:\Msg2\Fido\L\lotkids
        Renum Max   500
End MsgArea

MsgArea LOTUS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: LOTUS
        Tag         LOTUS
        Path        I:\Msg2\Fido\L\lotus
        Renum Max   300
End MsgArea

MsgArea LOVEMARR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Love & Marriage
        Tag         LOVE_&_MARRIAGE
        Path        I:\Msg2\Fido\L\Lovemarr
        Renum Max   500
End MsgArea

MsgArea LOWFAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Low Fat Cooking
        Tag         LOW-FAT
        Path        I:\Msg2\Fido\L\lowfat
        Renum Max   500
End MsgArea

MsgArea LVGAMBLR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Las Vegas Gambler
        Tag         LV_GAMBLER
        Path        I:\Msg2\Fido\L\Lvgamblr
        Renum Max   500
End MsgArea

MsgArea LYRICS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Lyric writers echo
        Tag         LYRICS
        Path        I:\Msg2\Fido\L\Lyrics
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-M Demoted DIVISION: FidoNet Areas M-MZ

MsgArea MAXDEV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MAXIMUS BBS Util
        Tag         MAX_DEV
        Path        I:\Msg2\Fido\M\Maxdev
        Renum Max   500
End MsgArea

MsgArea MBBS-WG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MBBS (WG) Discussion
        Tag         MBBS-WG
        Path        I:\Msg2\Fido\M\Mbbs-wg
        Renum Max   500
End MsgArea

MsgArea MCMAIL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: McMail Inet Email<->Fido
        Tag         MCMAIL
        Path        I:\Msg2\Fido\M\Mcmail
        Renum Max   500
End MsgArea

MsgArea MDNDPHLP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: MD NDP HLP ????????? No idea
        Tag         MDNDP_HLP
        Path        I:\Msg2\Fido\M\Mdndphlp
        Renum Max   500
End MsgArea

MsgArea MEALMSTR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Meal-Master Support Conf
        Tag         MEAL-MASTER
        Path        I:\Msg2\Fido\M\mealmstr
        Renum Max   1000
End MsgArea

MsgArea MECCA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Maximus MECCA Language Conf
        Tag         MECCA
        Path        I:\Msg2\Fido\M\mecca
        Renum Max   1000
End MsgArea

MsgArea MEDRAYS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Radiology (X-Ray, etc)
        Tag         MED_RAYS
        Path        I:\Msg2\Fido\M\medrays
        Renum Max   200
End MsgArea

MsgArea MEETAFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Meet Aft
        Tag         MEET_AFT
        Path        I:\Msg2\Fido\M\meetaft
        Renum Max   200
End MsgArea

MsgArea MELEE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MELEE & Banzai Software Sup
        Tag         MELEE
        Path        I:\Msg2\Fido\M\melee
        Renum Max   200
End MsgArea

MsgArea MEMORIES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Nostalgia
        Tag         MEMORIES
        Path        I:\Msg2\Fido\M\memories
        Renum Max   500
End MsgArea

MsgArea MENSA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Mensa, Intelligence, Educat
        Tag         MENSA
        Path        I:\Msg2\Fido\M\mensa
        Renum Max   300
End MsgArea

MsgArea MENISSU
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Men's Issues
        Tag         MENS_ISSUES
        Path        I:\Msg2\Fido\M\menissu
        Renum Max   300
End MsgArea

MsgArea MENTHLT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Mental Health
        Tag         MENTAL_HEALTH
        Path        I:\Msg2\Fido\M\menthlt
        Renum Max   300
End MsgArea

MsgArea METAUFO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Meta UFO Conf.
        Tag         META_UFO
        Path        I:\Msg2\Fido\M\Metaufo
        Renum Max   500
End MsgArea

MsgArea MSGEDEC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MSGED Echo
        Tag         MSGED_ECHO
        Path        I:\Msg2\Fido\M\Msgedec
        Renum Max   500
End MsgArea

MsgArea MFILPMSP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Mfile/PM Support
        Tag         MFILEPMSUP
        Path        I:\Msg2\Fido\M\mfilpmsp
        Renum Max   500
End MsgArea

MsgArea MICROCOM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Microcom Modem Support Echo
        Tag         MICROCOM
        Path        I:\Msg2\Fido\M\microcom
        Renum Max   300
End MsgArea

MsgArea MIDINET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MIDI-NET(tm) * Int' MIDI Conf
        Tag         MIDI-NET
        Path        I:\Msg2\Fido\M\midinet
        Renum Max   300
End MsgArea

MsgArea MIDIPROG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MIDI Software Programmer's Conf
        Tag         MIDI-PROGRAMMING
        Path        I:\Msg2\Fido\M\midiprog
        Renum Max   300
End MsgArea

MsgArea MIDRANGE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:IBM Mid Systems (S/3x & AS/400)
        Tag         MIDRANGE
        Path        I:\Msg2\Fido\M\midrange
        Renum Max   300
End MsgArea

MsgArea MILHIST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Military History
        Tag         MILHISTORY
        Path        I:\Msg2\Fido\M\milhist
        Renum Max   300
End MsgArea

MsgArea MILITIA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Militia Disc.
        Tag         MILITIA
        Path        I:\Msg2\Fido\M\Militia
        Renum Max   500
End MsgArea

MsgArea MILPEOPL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Military People
        Tag         MILITARY_PEOPLE
        Path        I:\Msg2\Fido\M\milpeopl
        Renum Max   300
End MsgArea

MsgArea MISSING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National Missing Persons Echo
        Tag         MISSING
        Path        I:\Msg2\Fido\M\missing
        Renum Max   1000
End MsgArea

MsgArea MISSCHLD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Missing Children Echo
        Tag         MISSING_CHILD
        Path        I:\Msg2\Fido\M\misschld
        Renum Max   1000
End MsgArea

MsgArea MLBASEBL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Major League Baseball
        Tag         ML-BASEBALL
        Path        I:\Msg2\Fido\M\mlbasebl
        Renum Max   300
End MsgArea

MsgArea MLM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Multi-Level Marketing Conf
        Tag         MLM
        Path        I:\Msg2\Fido\M\mlm
        Renum Max   300
End MsgArea

MsgArea MM1-TECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: MM1_TECH (Multimedia?)
        Tag         MM1_TECH
        Path        I:\Msg2\Fido\M\MM1-TECH
        Renum Max   500
End MsgArea

MsgArea MODEMS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MODEMS General Discussion
        Tag         MODEMS
        Path        I:\Msg2\Fido\M\Modems
        Renum Max   500
End MsgArea

MsgArea MODERATR
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Moderator's Discussion Echo
        Tag         MODERATOR
        Path        I:\Msg2\Fido\M\moderatr
        Renum Max   300
End MsgArea

MsgArea MODR8TR
        ACS         Asstsysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Moderator Echo
        Tag         MODR8TR
        Path        I:\Msg2\Fido\M\Modr8tr
        Renum Max   500
End MsgArea

MsgArea MODULA2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Modula-2 Programming Language
        Tag         MODULA-2
        Path        I:\Msg2\Fido\M\modula2
        Renum Max   300
End MsgArea

MsgArea MONTE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MONTY PYTHON CONFERENCE
        Tag         MONTE
        Path        I:\Msg2\Fido\M\monte
        Renum Max   500
End MsgArea

MsgArea MORMON
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MORMON Open Conference
        Tag         MORMON
        Path        I:\Msg2\Fido\M\mormon
        Renum Max   300
End MsgArea

MsgArea MOTRCYCL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: INTERNATIONAL echo,etc
        Tag         MOTORCYCLE
        Path        I:\Msg2\Fido\M\motrcycl
        Renum Max   500
End MsgArea

MsgArea MPD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Multiple Personality Disorder
        Tag         M_P_D
        Path        I:\Msg2\Fido\M\mpd
        Renum Max   300
End MsgArea

MsgArea MPS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MicroProse
        Tag         MPS
        Path        I:\Msg2\Fido\M\mps
        Renum Max   300
End MsgArea

MsgArea MROCKET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Model Rocketry
        Tag         MOD_ROCKETRY
        Path        I:\Msg2\Fido\M\Mrocket
        Renum Max   500
End MsgArea

MsgArea MSEXCEL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Microsoft Excel Discussion
        Tag         MS_EXCEL
        Path        I:\Msg2\Fido\M\msexcel
        Renum Max   300
End MsgArea

MsgArea MSWORD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Microsoft Word
        Tag         MS_WORD
        Path        I:\Msg2\Fido\M\msword
        Renum Max   300
End MsgArea

MsgArea MST3K
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Mystery Science Theater 3000
        Tag         MST3K
        Path        I:\Msg2\Fido\M\mst3k
        Renum Max   300
End MsgArea

MsgArea MTGTRADE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MTG Trade
        Tag         MTG_TRADE
        Path        I:\Msg2\Fido\M\mtgtrade
        Renum Max   200
End MsgArea

MsgArea MTGWOC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Magic the Gathering & Other -
        Tag         MTG_WOC
        Path        I:\Msg2\Fido\M\mtgwoc
        Renum Max   300
End MsgArea

MsgArea MTRLAMOD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Motorola Modems Disc
        Tag         MOTOROLA_MODEMS
        Path        I:\Msg2\Fido\M\Mtrlamod
        Renum Max   500
End MsgArea

MsgArea MUFFIN
        % This defines an EchoMail area called "MUFFIN", which is the
        % Maximus support echo.  This echo will be stored in the
        % Squish message format.

        ACS             Sysop

        Style           Squish Echo Pub RealName Audit
        Desc            FidoNet Echo: Muffin
        Tag             MUFFIN

        % "EchoMail" signifies that this is an EchoMail area.  This means
        % that Maximus will add SEEN-BYs, PATHs and other control items
        % to messages that it creates.  If you've specified a "MsgName",
        % then that name will be written to ECHOTOSS.LOG when Max
        % terminates.

        Path            I:\Msg2\Fido\M\Muffin

        % For EchoMail areas, you can also specify a custom origin line.
        %
        % Instead of using the default origin line, which is specified
        % in MAX.CTL (using the "Name" keyword), a custom origin line
        % may be used for each area.  The format of a custom origin is:
        %
        %       Origin <aka> [text]
        %
        % <aka> specifies the ZERO-BASED number of the address you wish
        % to insert at the end of the origin line, relative to the order
        % of your `Address' statements in MAX.CTL.  For example,
        % specifying an AKA of `0' uses the first address statement,
        % specifying `1' uses the SECOND address statement, etc.
        %
        % [text] is optional, and is simply the origin line you wish
        % to use for this area.  It may be up to 60 characters long,
        % and will get truncated if it is longer.  If you specify no
        % [text], or no origin statement altogether, then Maximus
        % will use the `System' line in MAX.CTL as the origin line
        % for this area.
        %       Origin  0       A chip off the old WOC
        Renum Max        300
End MsgArea

MsgArea MLTSCLRS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Multiple Sclerosis
        Tag         MULT-SCLEROSIS
        Path        I:\Msg2\Fido\M\mltsclrs
        Renum Max   300
End MsgArea

MsgArea MUPPETS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Muppets
        Tag         MUPPETS
        Path        I:\Msg2\Fido\M\muppets
        Renum Max   300
End MsgArea

MsgArea MUSE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Muse Studio (Poetry Disc)
        Tag         MUSE
        Path        I:\Msg2\Fido\M\muse
        Renum Max   300
End MsgArea

MsgArea MUSIC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Music Discussion of All Types
        Tag         MUSIC
        Path        I:\Msg2\Fido\M\music
        Renum Max   300
End MsgArea

MsgArea MUSICIAN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Musician Echo
        Tag         MUSICIAN
        Path        I:\Msg2\Fido\M\Musician
        Renum Max   500
End MsgArea

MsgArea MUSICCMP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Music Composition Conference
        Tag         MUSIC_COMP_101
        Path        I:\Msg2\Fido\M\musiccmp
        Renum Max   300
End MsgArea

MsgArea MUSICNSV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Musician's Classified Conf
        Tag         MUSICIAN'S_SERVICES
        Path        I:\Msg2\Fido\M\musicnsv
        Renum Max   300
End MsgArea

MsgArea MUSICSYN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: MUSICSYN echo
        Tag         MUSICSYN
        Path        I:\Msg2\Fido\M\musicsyn
        Renum Max   300
End MsgArea

MsgArea MWGENE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Midwest Genealogy Conference
        Tag         MW_GENE
        Path        I:\Msg2\Fido\M\mwgene
        Renum Max   300
End MsgArea

MsgArea MYSTERY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Mystery Fiction
        Tag         MYSTERY
        Path        I:\Msg2\Fido\M\mystery
        Renum Max   300
End MsgArea

MsgArea MYTHLGY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Mythology Conference
        Tag         MYTHOLOGY
        Path        I:\Msg2\Fido\M\mythlgy
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-N Demoted DIVISION: FidoNet Areas N-NZ

MsgArea NANFE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: NANFE ???
        Tag         NANFE
        Path        I:\Msg2\Fido\N\Nanfe
        Renum Max   500
End MsgArea

MsgArea NATFLEAM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National Flea Market
        Tag         NAT_FLEA_MKT
        Path        I:\Msg2\Fido\N\Natfleam
        Renum Max   500
End MsgArea

MsgArea NATURIST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: NATURIST
        Tag         NATURIST
        Path        I:\Msg2\Fido\N\naturist
        Renum Max   300
End MsgArea

MsgArea NAVY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: U.S. Navy Support Echo Conf
        Tag         NAVY
        Path        I:\Msg2\Fido\N\navy
        Renum Max   300
End MsgArea

MsgArea NBA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National Basketball Assoc
        Tag         NBA_ECHO
        Path        I:\Msg2\Fido\N\nba
        Renum Max   300
End MsgArea

MsgArea NDLSTHRD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Needles & Threads-Sewing
        Tag         NEEDLES_THREADS
        Path        I:\Msg2\Fido\N\Ndlsthrd
        Renum Max   500
End MsgArea

MsgArea NETDEV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet NetWork Developmnt
        Tag         NET_DEV
        Path        I:\Msg2\Fido\N\netdev
        Renum Max   300
End MsgArea

MsgArea NETLINE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: NETLINE ???
        Tag         NETLINE
        Path        I:\Msg2\Fido\N\Netline
        Renum Max   500
End MsgArea

MsgArea NETXPRES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Net Express
        Tag         NETXPRES
        Path        I:\Msg2\Fido\N\netxpres
        Renum Max   300
End MsgArea

MsgArea NEURAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Artificial Neural Network
        Tag         NEURAL_NET
        Path        I:\Msg2\Fido\N\neural
        Renum Max   300
End MsgArea

MsgArea NEUROL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: NEUROLOGY
        Tag         NEUROLOGY
        Path        I:\Msg2\Fido\N\neurol
        Renum Max   300
End MsgArea

MsgArea NEW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: NEW ???
        Tag         NEW
        Path        I:\Msg2\Fido\N\New
        Renum Max   500
End MsgArea

MsgArea NEWFILES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: New Files Reports
        Tag         NEWFILES
        Path        I:\Msg2\Fido\N\Newfiles
        Renum Max   300
End MsgArea

MsgArea NEWAGE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Friendly Discussion/New Age
        Tag         NEW_AGE_ECHO
        Path        I:\Msg2\Fido\N\newage
        Renum Max   300
End MsgArea

MsgArea NEWSCHAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet News Chat Conference
        Tag         NEWSCHAT
        Path        I:\Msg2\Fido\N\newschat
        Renum Max   300
End MsgArea

MsgArea NEWSYSOP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: New Sysop
        Tag         NEW_SYSOP
        Path        I:\Msg2\Fido\N\newsysop
        Renum Max   300
End MsgArea

MsgArea NWAVEMUS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: New Wave Music Discussion
        Tag         NEW_WAVE_MUSIC
        Path        I:\Msg2\Fido\N\Nwavemus
        Renum Max   500
End MsgArea

MsgArea NFBTALK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: NFB-Talk
        Tag         NFB-TALK
        Path        I:\Msg2\Fido\N\nfbtalk
        Renum Max   300
End MsgArea

MsgArea NFL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National Football League
        Tag         NFL
        Path        I:\Msg2\Fido\N\nfl
        Renum Max   300
End MsgArea

MsgArea NITESHFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Gramps Kiersarge & the Crew
        Tag         NIGHT_SHIFT
        Path        I:\Msg2\Fido\N\niteshft
        Renum Max   1000
End MsgArea

MsgArea NITSHFTA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Night Shift - Art Bell
        Tag         NIGHT_SHIFT_ART-BELL
        Path        I:\Msg2\Fido\N\nitshfta
        Renum Max   1000
End MsgArea

MsgArea NITSHFTC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Night Shift Cross Post
        Tag         NIGHT_SHIFT_CP
        Path        I:\Msg2\Fido\N\nitshftc
        Renum Max   1000
End MsgArea

MsgArea NITSHFTD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Debate Subjects/Night SHift
        Tag         NIGHT_SHIFT_DEBATE
        Path        I:\Msg2\Fido\N\nitshftd
        Renum Max   1000
End MsgArea

MsgArea NON-FICT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Non-Fiction
        Tag         NON-FICTION
        Path        I:\Msg2\Fido\N\non-fict
        Renum Max   200
End MsgArea

MsgArea NSCARDS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Non-Sport Cards
        Tag         NONSPORT_CARDS
        Path        I:\Msg2\Fido\N\nscards
        Renum Max   300
End MsgArea

MsgArea NOPIRACY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Piracy/Computer Crime Disc
        Tag         NOPIRACY
        Path        I:\Msg2\Fido\N\nopiracy
        Renum Max   300
End MsgArea

MsgArea NORML
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:ElctrncMediaVentureMarijuanaInf
        Tag         NORML
        Path        I:\Msg2\Fido\N\norml
        Renum Max   300
End MsgArea

MsgArea NOVELL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: NOVELL
        Tag         NOVELL
        Path        I:\Msg2\Fido\N\novell
        Renum Max   300
End MsgArea

MsgArea NURSNET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: NurseNet International
        Tag         NURSES_NETWORK
        Path        I:\Msg2\Fido\N\nursnet
        Renum Max   300
End MsgArea

MsgArea NUSUPPRT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: NU Support Echo
        Tag         NU_SUPPORT
        Path        I:\Msg2\Fido\N\Nusupprt
        Renum Max   500
End MsgArea

MsgArea NUTRITN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Nutrition
        Tag         NUTRITION
        Path        I:\Msg2\Fido\N\nutritio
        Renum Max   300
End MsgArea

MsgArea NWORDER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: New World Order
        Tag         NEW_WORLD_ORDER
        Path        I:\Msg2\Fido\N\Nworder
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-O Demoted DIVISION: FidoNet Areas O-OZ

MsgArea OASIS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Oasis
        Tag         OASIS
        Path        J:\Msg3\Fido\O\Oasis
        Renum Max   500
End MsgArea

MsgArea OFFLINE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Offline Readers,Doors, & Devel
        Tag         OFFLINE
        Path        J:\Msg3\Fido\O\offline
        Renum Max   500
End MsgArea

MsgArea OJSIMPSN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OJ_SIMPSON Discussion
        Tag         OJ_SIMPSON
        Path        J:\Msg3\Fido\O\ojsimpsn
        Renum Max   200
End MsgArea

MsgArea OKILLERS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Operation: Overkill BBS Door
        Tag         OKILLERS
        Path        J:\Msg3\Fido\O\okillers
        Renum Max   300
End MsgArea

MsgArea OLDCARS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Old Cars & Related Topics
        Tag         OLDCARS
        Path        J:\Msg3\Fido\O\oldcars
        Renum Max   500
End MsgArea

MsgArea OLDENGIN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        Old Engines
        Tag         OLD_ENGINE
        Path        J:\Msg3\Fido\O\Oldengin
        Renum Max   500
End MsgArea

MsgArea OLDTRUCK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Old Trucks & Related Topics
        Tag         OLDTRUCK
        Path        J:\Msg3\Fido\O\oldtruck
        Renum Max   300
End MsgArea

MsgArea OMEGASOF
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Omega Software
        Tag         OMEGA_SOFT
        Path        J:\Msg3\Fido\O\omegasof
        Renum Max   200
End MsgArea

MsgArea OMNINET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: OmniNET talk
        Tag         OMNINET
        Path        J:\Msg3\Fido\O\Omninet
        Renum Max   500
End MsgArea

MsgArea ONEFOS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: One FOS ??????
        Tag         ONEFOS
        Path        J:\Msg3\Fido\O\Onefos
        Renum Max   500
End MsgArea

MsgArea ONLINGAM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Talk About Fave ONLINE Game
        Tag         ON_LINE_GAMES
        Path        J:\Msg3\Fido\O\onlingam
        Renum Max   300
End MsgArea

MsgArea OOII
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Op Overkill BBS GAME etc
        Tag         OOII
        Path        J:\Msg3\Fido\O\ooii
        Renum Max   300
End MsgArea

MsgArea OPENBIBL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: O.T. & N.T. Intl Bible Study
        Tag         OPEN_BIBLE
        Path        J:\Msg3\Fido\O\openbibl
        Renum Max   300
End MsgArea

MsgArea OPENDOOR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OpenDoors Door Prog Toolkit
        Tag         OPENDOORS
        Path        J:\Msg3\Fido\O\opendoor
        Renum Max   300
End MsgArea

MsgArea OPTOMETR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Optometry/Eyecare Topics
        Tag         OPTOMETRY
        Path        J:\Msg3\Fido\O\optometr
        Renum Max   300
End MsgArea

MsgArea OSDEBATE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Operating System Debate
        Tag         OS-DEBATE
        Path        J:\Msg3\Fido\O\osdebate
        Renum Max   700
End MsgArea

MsgArea OS2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FIDOnet International OS/2
        Tag         OS2
        Path        J:\Msg3\Fido\O\os2
        Renum Max   700
End MsgArea

MsgArea OS2BBS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2 BBSing
        Tag         OS2BBS
        Path        J:\Msg3\Fido\O\os2bbs
        Renum Max   700
End MsgArea

MsgArea OS2BEGIN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: OS/2 For Beginners
        Tag         OS2BEGIN
        Path        J:\Msg3\Fido\O\Os2begin
        Renum Max   300
End MsgArea

MsgArea OS2CDROM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: OS/2 CD-ROM hardware disc
        Tag         OS2CDROM
        Path        J:\Msg3\Fido\O\Os2cdrom
        Renum Max   500
End MsgArea

MsgArea OS2COMM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        OS/2 Communications
        Tag         OS2COMM
        Path        J:\Msg3\Fido\O\os2comm
        Renum Max   500
End MsgArea

MsgArea OS2DDD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: OS2DDD ???
        Tag         OS2DDD
        Path        J:\Msg3\Fido\O\Os2ddd
        Renum Max   500
End MsgArea

MsgArea OS2DB
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: OS2DB ???
        Tag         OS2DB
        Path        J:\Msg3\Fido\O\Os2db
        Renum Max   500
End MsgArea

MsgArea OS2DOS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2: DOS & Windows Apps
        Tag         OS2DOS
        Path        J:\Msg3\Fido\O\os2dos
        Renum Max   700
End MsgArea

MsgArea OS2DOSBB
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sup DOS BBS sw under OS/2
        Tag         OS2DOSBBS
        Path        J:\Msg3\Fido\O\os2dosbb
        Renum Max   700
End MsgArea

MsgArea OS2GAMES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2 Games
        Tag         OS2GAMES
        Path        J:\Msg3\Fido\O\os2games
        Renum Max   300
End MsgArea

MsgArea OS2HW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2 Hardware
        Tag         OS2HW
        Path        J:\Msg3\Fido\O\os2hw
        Renum Max   700
End MsgArea

MsgArea OS2INET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2 Internet Discussion
        Tag         OS2INET
        Path        J:\Msg3\Fido\O\Os2inet
        Renum Max   500
End MsgArea

MsgArea OS2LAN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2 Local MsgArea Networks
        Tag         OS2LAN
        Path        J:\Msg3\Fido\O\os2lan
        Renum Max   700
End MsgArea

MsgArea OS2PROG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2 Programming Echo
        Tag         OS2PROG
        Path        J:\Msg3\Fido\O\os2prog
        Renum Max   700
End MsgArea

MsgArea OS2REXX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        OS/2 Rexx Programming
        Tag         OS2REXX
        Path        J:\Msg3\Fido\O\os2rexx
        Renum Max   500
End MsgArea

MsgArea OS2VIDEO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2 Video Hardware/Soft
        Tag         OS2VIDEO
        Path        J:\Msg3\Fido\O\Os2video
        Renum Max   500
End MsgArea

MsgArea OS2-WP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: OS2_WP ???????????
        Tag         OS2_WP
        Path        J:\Msg3\Fido\O\Os2-wp
        Renum Max   500
End MsgArea

MsgArea OTHRNETS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Othernets: Info on Other Nets
        Tag         OTHERNETS
        Path        J:\Msg3\Fido\O\othrnets
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-P Demoted DIVISION: FidoNet Areas P-PZ

MsgArea P5DRAFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: P5 Draft
        Tag         P5DRAFT
        Path        J:\Msg3\Fido\P\p5draft
        Renum Max   200
End MsgArea

MsgArea PACKET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Amateur Radio Packet Echo
        Tag         PACKET
        Path        J:\Msg3\Fido\P\packet
        Renum Max   300
End MsgArea

MsgArea PROTOSTR
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Protostar
        Tag         PROTOSTAR
        Path        J:\Msg3\Fido\P\protostr
        Renum Max   300
End MsgArea

MsgArea PAOANNCE
        ACS         Asstsysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PaOnline Announce
        Tag         PAONLINE_ANNOUNCE
        Path        J:\Msg3\Fido\P\Paoannce
        Renum Max   500
End MsgArea

MsgArea PAOFTPHB
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PA Online FTP HUB
        Tag         PAONLINE_FTPHUB
        Path        J:\Msg3\Fido\P\paoftphb
        Renum Max   300
End MsgArea

MsgArea PSDAILY
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PS Daily
        Tag         PS_DAILY
        Path        J:\Msg3\Fido\P\psdaily
        Renum Max   300
End MsgArea

MsgArea PSMNTHLY
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PS Monthly
        Tag         PS_MONTHLY
        Path        J:\Msg3\Fido\P\psmnthly
        Renum Max   300
End MsgArea

MsgArea PSWEEKLY
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PS Weekly
        Tag         PS_WEEKLY
        Path        J:\Msg3\Fido\P\psweekly
        Renum Max   300
End MsgArea

MsgArea PAOANNCE
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PAONLINE Announce
        Tag         PAONLINE_ANNOUNCE
        Path        J:\Msg3\Fido\P\paoannce
        Renum Max   300
End MsgArea

MsgArea PARALEGL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PARALEGAL
        Tag         PARALEGAL
        Path        J:\Msg3\Fido\P\paralegl
        Renum Max   300
End MsgArea

MsgArea PARENTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Parents echo
        Tag         PARENTS
        Path        J:\Msg3\Fido\P\parents
        Renum Max   300
End MsgArea

MsgArea PARROTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PARROTS CONFERENCE
        Tag         PARROTS
        Path        J:\Msg3\Fido\P\parrots
        Renum Max   300
End MsgArea

MsgArea PASCAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PASCAL
        Tag         PASCAL
        Path        J:\Msg3\Fido\P\pascal
        Renum Max   1000
End MsgArea

MsgArea PASLESN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PASCAL_LESSONS
        Tag         PASCAL_LESSONS
        Path        J:\Msg3\Fido\P\paslesn
        Renum Max   1000
End MsgArea

MsgArea PATCHES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Public Service Patch Traders
        Tag         PATCHES
        Path        J:\Msg3\Fido\P\patches
        Renum Max   300
End MsgArea

MsgArea PAULREVR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Paul Revere
        Tag         PAUL_REVERE
        Path        J:\Msg3\Fido\P\Paulrvr
        Renum Max   300
End MsgArea

MsgArea PCADDICT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Computer Addicts Conference
        Tag         PC_ADDICT
        Path        J:\Msg3\Fido\P\pcaddict
        Renum Max   500
End MsgArea

MsgArea PCCONSLT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PC Consultants Echo
        Tag         PC_CONSULT
        Path        J:\Msg3\Fido\P\pcconslt
        Renum Max   300
End MsgArea

MsgArea PCUG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PC User Groups
        Tag         PCUG
        Path        J:\Msg3\Fido\P\pcug
        Renum Max   300
End MsgArea

MsgArea PCWRITE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PCWRITE Word Processor
        Tag         PCWRITE
        Path        J:\Msg3\Fido\P\pcwrite
        Renum Max   300
End MsgArea

MsgArea PDNECHO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Programmer's Dist Network
        Tag         PDNECHO
        Path        J:\Msg3\Fido\P\pdnecho
        Renum Max   300
End MsgArea

MsgArea PENPAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: PenPals Echo
        Tag         PENPAL
        Path        J:\Msg3\Fido\P\Penpal
        Renum Max   300
End MsgArea

MsgArea PETCHAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pet Chat Echo
        Tag         PET_CHAT
        Path        J:\Msg3\Fido\P\Petchat
        Renum Max   500
End MsgArea

MsgArea PETADOPT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Pet Adoptions
        Tag         PETADOPT
        Path        J:\Msg3\Fido\P\Petadopt
        Renum Max   500
End MsgArea

MsgArea PGMRS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Programmers Echo
        Tag         PGMRS
        Path        J:\Msg3\Fido\P\Pgmrs
        Renum Max   500
End MsgArea

MsgArea PHARMACY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Medication & Pharmaceuticals
        Tag         PHARMACY
        Path        J:\Msg3\Fido\P\pharmacy
        Renum Max   300
End MsgArea

MsgArea PHIL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Philosophy
        Tag         PHIL
        Path        J:\Msg3\Fido\P\phil
        Renum Max   300
End MsgArea

MsgArea PHONES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: A Telephone Industry Watchdog
        Tag         PHONES
        Path        J:\Msg3\Fido\P\phones
        Renum Max   3000
End MsgArea

MsgArea PHOTO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Photo Conference
        Tag         PHOTO
        Path        J:\Msg3\Fido\P\photo
        Renum Max   300
End MsgArea

MsgArea PHYSICS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PHYSICS
        Tag         PHYSICS
        Path        J:\Msg3\Fido\P\physics
        Renum Max   300
End MsgArea

MsgArea PIERS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PIERS
        Tag         PIERS
        Path        J:\Msg3\Fido\P\piers
        Renum Max   500
End MsgArea

MsgArea PINK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pink Floyd
        Tag         PINK
        Path        J:\Msg3\Fido\P\pink
        Renum Max   300
End MsgArea

MsgArea PKEYDROP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Public-Key Distribution Echo
        Tag         PKEY_DROP
        Path        J:\Msg3\Fido\P\pkeydrop
        Renum Max   300
End MsgArea

MsgArea PLEASE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Stop Cycle of Child ABuse(Sup.)
        Tag         PLEASE
        Path        J:\Msg3\Fido\P\please
        Renum Max   300
End MsgArea

MsgArea PNEWS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Progressive News & Views
        Tag         P_NEWS
        Path        J:\Msg3\Fido\P\pnews
        Renum Max   300
End MsgArea

MsgArea POETRWRK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The Poetry Workshop
        Tag         POETRY_WORKSHOP
        Path        J:\Msg3\Fido\P\poetrwrk
        Renum Max   300
End MsgArea

MsgArea POINTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Points Usage Discussion
        Tag         POINTS
        Path        J:\Msg3\Fido\P\points
        Renum Max   300
End MsgArea

MsgArea POLITICS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Political Discussions
        Tag         POLITICS
        Path        J:\Msg3\Fido\P\politics
        Renum Max   300
End MsgArea

MsgArea POLSKAGN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Polish Geneaology
        Tag         POLSKA.GEN
        Path        J:\Msg3\Fido\P\Polskagn
        Renum Max   500
End MsgArea

MsgArea POSTPLIO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Intnatl Post-Polio Survivors
        Tag         POST_POLIO
        Path        J:\Msg3\Fido\P\postplio
        Renum Max   300
End MsgArea

MsgArea POWERBAS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PowerBASIC Programmer's Conf
        Tag         POWER_BAS
        Path        J:\Msg3\Fido\P\powerbas
        Renum Max   300
End MsgArea

MsgArea PPIMODEM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Practical Periphls Modem Sup
        Tag         PPI_MODEMS
        Path        J:\Msg3\Fido\P\ppimodem
        Renum Max   300
End MsgArea

MsgArea PROAUDIO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PROFESSIONAL AUDIO
        Tag         PRO_AUDIO
        Path        J:\Msg3\Fido\P\proaudio
        Renum Max   300
End MsgArea

MsgArea PROLIFE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pro-Life Discussion
        Tag         PRO_LIFE
        Path        J:\Msg3\Fido\P\prolife
        Renum Max   300
End MsgArea

MsgArea PROVIDEO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PROFESSIONAL VIDEO
        Tag         PRO_VIDEO
        Path        J:\Msg3\Fido\P\provideo
        Renum Max   300
End MsgArea

MsgArea PROBCHLD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Problem Children
        Tag         PROBLEM_CHILD
        Path        J:\Msg3\Fido\P\probchld
        Renum Max   300
End MsgArea

MsgArea PROWRITE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Professional Writers
        Tag         PROWRITE
        Path        J:\Msg3\Fido\P\prowrite
        Renum Max   300
End MsgArea

MsgArea PROZ
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PROZ Software Product Sup
        Tag         PROZ
        Path        J:\Msg3\Fido\P\proz
        Renum Max   300
End MsgArea

MsgArea PSDAILY
        ACS         Privil
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Paonline Services Daily
        Tag         PS_DAILY
        Path        J:\Msg3\Fido\P\Psdaily
        Renum Max   300
End MsgArea

MsgArea PUBKEYS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Public-Key Encryption/Dist
        Tag         PUBLIC_KEYS
        Path        J:\Msg3\Fido\P\pubkeys
        Renum Max   300
End MsgArea

MsgArea PUBPSYC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: PUBLIC PSYCHOLOGY Supp. Conf.
        Tag         PUBLIC_PSYCH
        Path        J:\Msg3\Fido\P\pubpsyc
        Renum Max   300
End MsgArea

MsgArea PYRO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National Pyrotechnic Echo
        Tag         PYRO
        Path        J:\Msg3\Fido\P\pyro
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-Q Demoted DIVISION: FidoNet Areas Q-QZ

MsgArea QEDIT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Qedit
        Tag         QEDIT
        Path        J:\Msg3\Fido\Q\qedit
        Renum Max   300
End MsgArea

MsgArea QMODEMUS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: QModem Users Conf.
        Tag         QMODEM_USER
        Path        J:\Msg3\Fido\Q\qmodemus
        Renum Max   300
End MsgArea

MsgArea QNTMLEAP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Quantum Leap Echo
        Tag         QUANTUMLEAP
        Path        J:\Msg3\Fido\Q\qntmleap
        Renum Max   300
End MsgArea

MsgArea QUICKEN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Quicken Software Help Conf
        Tag         QUICKEN
        Path        J:\Msg3\Fido\Q\quicken
        Renum Max   300
End MsgArea

MsgArea QUIKBAS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Disc QuickBasic Prog & Lang
        Tag         QUIK_BAS
        Path        J:\Msg3\Fido\Q\quikbas
        Renum Max   700
End MsgArea

MsgArea QUOTES2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Quotes 2
        Tag         QUOTES_2
        Path        J:\Msg3\Fido\Q\quotes2
        Renum Max   300
End MsgArea

MsgArea QURAN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Qur'An
        Tag         QUR'AN
        Path        J:\Msg3\Fido\Q\quran
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-R Demoted DIVISION: FidoNet Areas R-RZ

MsgArea RACESIMS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Racing Simulations
        Tag         RACING_SIMS
        Path        J:\Msg3\Fido\R\racesims
        Renum Max   300
End MsgArea

MsgArea RACEUNTY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Race Unity
        Tag         RACE_UNITY
        Path        J:\Msg3\Fido\R\Raceunty
        Renum Max   500
End MsgArea

MsgArea RAHOBALL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Radio Hobbies All
        Tag         RADIO_HOBBY-ALL
        Path        J:\Msg3\Fido\R\Rahoball
        Renum Max   500
End MsgArea

MsgArea RAILFANS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Railfans,TrainWatching,Proto
        Tag         RAILFANS
        Path        J:\Msg3\Fido\R\railfans
        Renum Max   300
End MsgArea

MsgArea RANMA12
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RANMA 1/2 <???>
        Tag         RANMA_1/2
        Path        J:\Msg3\Fido\R\Ranma12
        Renum Max   500
End MsgArea

MsgArea RAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RAR
        Tag         RAR
        Path        J:\Msg3\Fido\R\rar
        Renum Max   300
End MsgArea

MsgArea RARECOND
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Rare Diseases
        Tag         RARE_CONDITION
        Path        J:\Msg3\Fido\R\rarecond
        Renum Max   300
End MsgArea

MsgArea RAUSW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: RAUSW ?? <not in my list>
        Tag         RAUSW
        Path        J:\Msg3\Fido\R\Rausw
        Renum Max   500
End MsgArea

MsgArea RCATHLIC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Roman Catholic Q&A Forum
        Tag         R_CATHOLIC
        Path        J:\Msg3\Fido\R\rcathlic
        Renum Max   300
End MsgArea

MsgArea RCM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RC Models II
        Tag         RCM
        Path        J:\Msg3\Fido\R\rcm
        Renum Max   300
End MsgArea

MsgArea RCMODEL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Radio Controlled Modeling
        Tag         RC_MODEL
        Path        J:\Msg3\Fido\R\Rcmodel
        Renum Max   500
End MsgArea

MsgArea RCP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Rcp (?)
        Tag         RCP
        Path        J:\Msg3\Fido\R\rcp
        Renum Max   300
End MsgArea

MsgArea REALFS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: REAL Free Speech
        Tag         REAL_FREE_SPEECH
        Path        J:\Msg3\Fido\R\realfs
        Renum Max   300
End MsgArea

MsgArea RECFRP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Role Playing Games
        Tag         RECFRP
        Path        J:\Msg3\Fido\R\recfrp
        Renum Max   300
End MsgArea


MsgArea RECIPES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Recipes
        Tag         RECIPES
        Path        J:\Msg3\Fido\R\recipes
        Renum Max   300
End MsgArea

MsgArea RECOVERY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: 12 Step Oriented Recovery
        Tag         RECOVERY
        Path        J:\Msg3\Fido\R\recovery
        Renum Max   300
End MsgArea

MsgArea REDCROSS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Red Cross Discussion
        Tag         RED_CROSS
        Path        J:\Msg3\Fido\R\Redcross
        Renum Max   300
End MsgArea

MsgArea REEFKEEP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Saltwater/Reef Keeping Inf
        Tag         REEF_KEEPING
        Path        J:\Msg3\Fido\R\reefkeep
        Renum Max   300
End MsgArea

MsgArea REENACT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Reenacting & Living History
        Tag         REENACT
        Path        J:\Msg3\Fido\R\reenact
        Renum Max   300
End MsgArea

MsgArea RELOAD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Reloading for Rifle&Pistol
        Tag         RELOAD
        Path        J:\Msg3\Fido\R\reload
        Renum Max   500
End MsgArea

MsgArea RIGHTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Gender Equality & RIGHTS
        Tag         RIGHTS
        Path        J:\Msg3\Fido\R\rights
        Renum Max   300
End MsgArea

MsgArea RITERONG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Rights / Wrongs
        Tag         RIGHTS_RONGS
        Path        J:\Msg3\Fido\R\riterong
        Renum Max   300
End MsgArea

MsgArea ROBOTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RoboTech
        Tag         ROBOTECH
        Path        J:\Msg3\Fido\R\robotech
        Renum Max   300
End MsgArea

MsgArea ROMSTEMP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Romulan Star Empire Disc
        Tag         ROMULAN_STAR_EMPIRE
        Path        J:\Msg3\Fido\R\Romstemp
        Renum Max   500
End MsgArea

MsgArea RPGGENRL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RPG General Disc.
        Tag         RPG_GENERAL
        Path        J:\Msg3\Fido\R\Rpggenrl
        Renum Max   500
End MsgArea

MsgArea RTKBA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: GUN RIGHTS/GUN CONTROL Disc
        Tag         RTKBA
        Path        J:\Msg3\Fido\R\rtkba
        Renum Max   300
End MsgArea

MsgArea RTSOFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RTSOFT
        Tag         RTSOFT
        Path        J:\Msg3\Fido\R\rtsoft
        Renum Max   200
End MsgArea

MsgArea RTTY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: RTTY,SITOR,FAX,CW over Radio
        Tag         RTTY
        Path        J:\Msg3\Fido\R\rtty
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-S Demoted DIVISION: FidoNet Areas S-SZ

MsgArea SAILING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SAILING
        Tag         SAILING
        Path        J:\Msg3\Fido\S\sailing
        Renum Max   300
End MsgArea

MsgArea SALRMOON
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sailor Moon Echo
        Tag         SAILOR_MOON
        Path        J:\Msg3\Fido\S\Salrmoon
        Renum Max   500
End MsgArea

MsgArea SALVARMY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Salvation Army Disc
        Tag         SALVATION_ARMY
        Path        J:\Msg3\Fido\S\Salvarmy
        Renum Max   500
End MsgArea

MsgArea SAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Search & Rescue Discussion
        Tag         SAR
        Path        J:\Msg3\Fido\S\sar
        Renum Max   300
End MsgArea

MsgArea SBENL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit ReadOnly
        Desc        FIDOnet Echo: SpaceBase's READONLY ElecNews
        Tag         SB-E/N/L
        Path        J:\Msg3\Fido\S\sbenl
        Renum Max   300
End MsgArea

MsgArea SBNNEWS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit ReadOnly
        Desc        FIDOnet Echo: SpaceBase READONLY NasaNews
        Tag         SB-NASA_NEWS
        Path        J:\Msg3\Fido\S\sbnnews
        Renum Max   300
End MsgArea

MsgArea SBNTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit ReadOnly
        Desc        FIDOnet Echo: SpaceBase READONLY NasaTechNews
        Tag         SB-NASA_TECH
        Path        J:\Msg3\Fido\S\sbntech
        Renum Max   300
End MsgArea

MsgArea SBQUEST
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SpaceBase DiscEcho/Space News
        Tag         SB-QUESTIONS
        Path        J:\Msg3\Fido\S\sbquest
        Renum Max   500
End MsgArea

MsgArea SBSTRACK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SpaceBase AmSat Tracking
        Tag         SB-SAT_TRACK
        Path        J:\Msg3\Fido\S\sbstrack
        Renum Max   300
End MsgArea

MsgArea SBSOLRRP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SpaceBase Solar Activity Rpts
        Tag         SB-SOLAR_RPT
        Path        J:\Msg3\Fido\S\sbsolrrp
        Renum Max   300
End MsgArea

MsgArea SBSYSOPS
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SpaceBase's Sysop's Only Conf
        Tag         SB-SYSOPS
        Path        J:\Msg3\Fido\S\sbsysops
        Renum Max   300
End MsgArea

MsgArea SBWORLDN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit ReadOnly
        Desc        FIDOnet Echo: SpaceBase READONLY WorldSpace
        Tag         SB-WORLD_NWS
        Path        J:\Msg3\Fido\S\sbworldn
        Renum Max   300
End MsgArea

MsgArea SCANRADI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Scanner Radios - Equip & Freq
        Tag         SCANRADIO
        Path        J:\Msg3\Fido\S\scanradi
        Renum Max   300
End MsgArea

MsgArea SCITECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Science & Technology Conf
        Tag         SCI&TECH
        Path        J:\Msg3\Fido\S\scitech
        Renum Max   300
End MsgArea

MsgArea SCIENCE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National Science Echo
        Tag         SCIENCE
        Path        J:\Msg3\Fido\S\science
        Renum Max   300
End MsgArea

MsgArea SCNCHEAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SCN Cheats Echo
        Tag         SCN_CHEAT
        Path        J:\Msg3\Fido\S\Scncheat
        Renum Max   500
End MsgArea

MsgArea SCOUTER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Scouter Echo
        Tag         SCOUTER
        Path        J:\Msg3\Fido\S\Scouter
        Renum Max   500
End MsgArea

MsgArea SCOUTING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International SCOUTING Conf
        Tag         SCOUTING
        Path        J:\Msg3\Fido\S\scouting
        Renum Max   300
End MsgArea

MsgArea SCUBA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Scuba Diving
        Tag         SCUBA
        Path        J:\Msg3\Fido\S\scuba
        Renum Max   300
End MsgArea

MsgArea SEEDSWAP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SeedSwap
        Tag         SEEDSWAP
        Path        J:\Msg3\Fido\S\seedswap
        Renum Max   300
End MsgArea

MsgArea SEGENEAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: South Eastern US Genealogy
        Tag         SE_GENEALOGY
        Path        J:\Msg3\Fido\S\segeneal
        Renum Max   300
End MsgArea

MsgArea SET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: SET ??
        Tag         SET
        Path        J:\Msg3\Fido\S\Set
        Renum Max   500
End MsgArea

MsgArea SEWQUILT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sewing & Quilting
        Tag         SEW_&_QUILT
        Path        J:\Msg3\Fido\S\sewquilt
        Renum Max   300
End MsgArea

MsgArea SF
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SciFi & Fantasy Lit
        Tag         SF
        Path        J:\Msg3\Fido\S\sf
        Renum Max   300
End MsgArea

MsgArea SFNANIME
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sci-Fi & Anime RPGames etc
        Tag         SF&ANIME_RPG
        Path        J:\Msg3\Fido\S\sfnanime
        Renum Max   300
End MsgArea

MsgArea SFFAN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Science Fiction & Fandom
        Tag         SFFAN
        Path        J:\Msg3\Fido\S\sffan
        Renum Max   300
End MsgArea

MsgArea SHAREWRE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Shareware General Disc
        Tag         SHAREWRE
        Path        J:\Msg3\Fido\S\Sharewre
        Renum Max   300
End MsgArea

MsgArea SHARESUP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Shareware Products Support
        Tag         SHAREWARE_SUPPORT
        Path        J:\Msg3\Fido\S\sharesup
        Renum Max   300
End MsgArea

MsgArea SHARING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sharing
        Tag         SHARING
        Path        J:\Msg3\Fido\S\Sharing
        Renum Max   500
End MsgArea

MsgArea SHINSTAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Shining Star (software ? )
        Tag         SHINING*STAR
        Path        J:\Msg3\Fido\S\Shinstar
        Renum Max   500
End MsgArea

MsgArea SHORTWAV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Shortwave Listener's Conf
        Tag         SHORTWAVE
        Path        J:\Msg3\Fido\S\shortwav
        Renum Max   300
End MsgArea

MsgArea SIERRAN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sierra Club (Environment)
        Tag         SIERRAN
        Path        J:\Msg3\Fido\S\sierran
        Renum Max   300
End MsgArea

MsgArea SILNTALK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Conf. for the Deaf&HardofHearng
        Tag         SILENTTALK
        Path        J:\Msg3\Fido\S\silntalk
        Renum Max   300
End MsgArea

MsgArea SIM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SIMulation & Wargaming
        Tag         SIM
        Path        J:\Msg3\Fido\S\sim
        Renum Max   300
End MsgArea

MsgArea SIMPSONS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The SIMPSONS Discussion echo
        Tag         SIMPSONS
        Path        J:\Msg3\Fido\S\simpsons
        Renum Max   300
End MsgArea

MsgArea SINGLMOM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The SINGLE MOMS Discussion
        Tag         SINGLE_MOMS
        Path        J:\Msg3\Fido\S\singlmom
        Renum Max   300
End MsgArea

MsgArea SNGLPRNT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Single Parent
        Tag         SINGLE_PARENT
        Path        J:\Msg3\Fido\S\snglprnt
        Renum Max   500
End MsgArea

MsgArea SNGLPRNN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Single Parenting
        Tag         SINGLE_PARENTING
        Path        J:\Msg3\Fido\S\Snglprnn
        Renum Max   500
End MsgArea

MsgArea SIPAA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Alcoholism & Recovery
        Tag         SIP_AA
        Path        J:\Msg3\Fido\S\sipaa
        Renum Max   300
End MsgArea

MsgArea SIPAABUS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SIP Alcohol Abuse
        Tag         SIP_AABUS
        Path        J:\Msg3\Fido\S\Sipaabus
        Renum Max   500
End MsgArea

MsgArea SIPALANN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SIP Alcoholics Anonymous
        Tag         SIP_ALANON
        Path        J:\Msg3\Fido\S\Sipalann
        Renum Max   500
End MsgArea

MsgArea SIPACA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Adult Children of Alcoholics
        Tag         SIP_ACA
        Path        J:\Msg3\Fido\S\sipaca
        Renum Max   300
End MsgArea

MsgArea SIPINCES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Incest Survivor's Conference
        Tag         SIP_INCEST
        Path        J:\Msg3\Fido\S\sipinces
        Renum Max   300
End MsgArea

MsgArea SIPMPD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Singleness in Purpose-MultPrsn
        Tag         SIP_MPD
        Path        J:\Msg3\Fido\S\sipmpd
        Renum Max   300
End MsgArea

MsgArea SIPNA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Narcotics Anonymous Echo
        Tag         SIP_NA
        Path        J:\Msg3\Fido\S\sipna
        Renum Max   300
End MsgArea

MsgArea SIPSAA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:12Step Recov/Sexual Addict
        Tag         SIP_SAA
        Path        J:\Msg3\Fido\S\sipsaa
        Renum Max   300
End MsgArea

MsgArea SIPSSAS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spouses of Sexual Abuse Surv
        Tag         SIP_SSAS
        Path        J:\Msg3\Fido\S\sipssas
        Renum Max   300
End MsgArea

MsgArea SIPSRVIV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:12Step Disc/Surv. Sexual Abuse
        Tag         SIP_SURVIVOR
        Path        J:\Msg3\Fido\S\sipsrviv
        Renum Max   300
End MsgArea

MsgArea SKEPTIC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Skeptical Inquiry Echo
        Tag         SKEPTIC
        Path        J:\Msg3\Fido\S\skeptic
        Renum Max   300
End MsgArea

MsgArea SKING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Disc Stephen King & works
        Tag         S_KING
        Path        J:\Msg3\Fido\S\sking
        Renum Max   300
End MsgArea

MsgArea SMOKRITS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Smoker's Rights
        Tag         SMOKERS_RIGHTS
        Path        J:\Msg3\Fido\S\smokrits
        Renum Max   300
End MsgArea

MsgArea SOAPS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SOAPS
        Tag         SOAPS
        Path        J:\Msg3\Fido\S\soaps
        Renum Max   500
End MsgArea

MsgArea SOFMARKT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Software Marketing/Business
        Tag         SOFTWARE_MARKETING
        Path        J:\Msg3\Fido\S\sofmarkt
        Renum Max   300
End MsgArea

MsgArea SOFTNET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: SOFTNET ??
        Tag         SOFTNET
        Path        J:\Msg3\Fido\S\Softnet
        Renum Max   500
End MsgArea

MsgArea SPACE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Space Development Conf
        Tag         SPACE
        Path        J:\Msg3\Fido\S\space
        Renum Max   300
End MsgArea

MsgArea SPANGEN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spanish Genealogy Conf
        Tag         SPANISH.GEN
        Path        J:\Msg3\Fido\S\spangen
        Renum Max   300
End MsgArea

MsgArea SPIRITUA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Spirituality & WorldPeace Ec
        Tag         SPIRITUAL
        Path        J:\Msg3\Fido\S\spiritua
        Renum Max   300
End MsgArea

MsgArea SPRTFSHW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Fishing the North
        Tag         SPORT-FISHING.WEST
        Path        J:\Msg3\Fido\S\sprtfshw
        Renum Max   300
End MsgArea

MsgArea SPORTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sports
        Tag         SPORTS
        Path        J:\Msg3\Fido\S\sports
        Renum Max   300
End MsgArea

MsgArea SQDSV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sea Quest DSV
        Tag         SQDSV
        Path        J:\Msg3\Fido\S\sqdsv
        Renum Max   300
End MsgArea

MsgArea SRA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Survivors of Ritual Abuse
        Tag         SRA
        Path        J:\Msg3\Fido\S\sra
        Renum Max   300
End MsgArea

MsgArea SRGAMES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Solar Realm Games
        Tag         SRGAMES
        Path        J:\Msg3\Fido\S\srgames
        Renum Max   300
End MsgArea

MsgArea ST-PROG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Atari ST Programming Echo
        Tag         ST_PROG
        Path        J:\Msg3\Fido\S\st-prog
        Renum Max   300
End MsgArea

MsgArea STAMPS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Stamps & Collecting (?)
        Tag         STAMPS
        Path        J:\Msg3\Fido\S\stamps
        Renum Max   300
End MsgArea

MsgArea STARTREK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Star Trek Role Playing Echo
        Tag         STARTREK
        Path        J:\Msg3\Fido\S\startrek
        Renum Max   300
End MsgArea

MsgArea STRTRKCC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: STARTREK CCG
        Tag         STARTREK_CCG
        Path        J:\Msg3\Fido\S\strtrkcc
        Renum Max   300
End MsgArea

MsgArea STRTRKRP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: StarTrek RolePlaying Conf
        Tag         STARTREK_RPG
        Path        J:\Msg3\Fido\S\strtrkrp
        Renum Max   300
End MsgArea

MsgArea STARWARS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: STAR WARS conf. echo
        Tag         STARWARS
        Path        J:\Msg3\Fido\S\starwars
        Renum Max   1000
End MsgArea

MsgArea STDSN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Star Trek: Deep Space Nine
        Tag         STDSN
        Path        J:\Msg3\Fido\S\stdsn
        Renum Max   300
End MsgArea

MsgArea STCKMRKT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Discuss Investments Trading
        Tag         STOCK_MARKET
        Path        J:\Msg3\Fido\S\stckmrkt
        Renum Max   300
End MsgArea

MsgArea STEPPRNT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Step Parenting
        Tag         STEP_PARENT
        Path        J:\Msg3\Fido\S\Stepprnt
        Renum Max   500
End MsgArea

MsgArea STOPSMOK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Stop Smoking
        Tag         STOP_SMOKING
        Path        J:\Msg3\Fido\S\stopsmok
        Renum Max   300
End MsgArea

MsgArea STRSMGMT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Reducs/Eliminate STRESS
        Tag         STRESS_MGMT
        Path        J:\Msg3\Fido\S\strsmgmt
        Renum Max   300
End MsgArea

MsgArea STS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: STS Echo
        Tag         STS
        Path        J:\Msg3\Fido\S\sts
        Renum Max   300
End MsgArea

MsgArea STTNG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Star Trek: The Next Gen
        Tag         STTNG
        Path        J:\Msg3\Fido\S\sttng
        Renum Max   300
End MsgArea

MsgArea STUDI101
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Studio & Live Music Perf
        Tag         STUDIO_101
        Path        J:\Msg3\Fido\S\studi101
        Renum Max   300
End MsgArea

MsgArea SUPRAFAX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Intnl Suprafax Modem Conf
        Tag         SUPRAFAX
        Path        J:\Msg3\Fido\S\suprafax
        Renum Max   300
End MsgArea

MsgArea SURVIVOR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Cancr/Leuk/Blood&ImmuneSys
        Tag         SURVIVOR
        Path        J:\Msg3\Fido\S\survivor
        Renum Max   300
End MsgArea

MsgArea SUSTAG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sustainable Agriculture
        Tag         SUST_AG
        Path        J:\Msg3\Fido\S\sustag
        Renum Max   300
End MsgArea

MsgArea SYS4SALE
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Sysop Sales MsgArea
        Tag         SYS4SALE
        Path        J:\Msg3\Fido\S\sys4sale
        Renum Max   300
End MsgArea

MsgArea SYSOP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Sysop Conf.
        Tag         SYSOP
        Path        J:\Msg3\Fido\S\sysop
        Renum Max   300
End MsgArea

MsgArea SYSOPS
        ACS         Asstsysop
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Sysops Echo
        Tag         SYSOPS
        Path        J:\Msg3\Fido\S\Sysops
        Renum Max   500
End MsgArea

MsgArea SYSOPISS
        ACS         Asstsysop
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Sysop Issues
        Tag         SYSOP_ISSUES
        Path        J:\Msg3\Fido\S\Sysopiss
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin Fido-T Demoted DIVISION: FidoNet Areas T-TZ

MsgArea TABLTRE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Guitar Tablature
        Tag         TABLATURE
        Path        J:\Msg3\Fido\T\tabltre
        Renum Max   300
End MsgArea

MsgArea TAGLINES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: TAGLINES
        Tag         TAGLINES
        Path        J:\Msg3\Fido\T\taglines
        Renum Max   300
End MsgArea

MsgArea TCM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Trdtnl Asian Med&Bodywork
        Tag         TCM
        Path        J:\Msg3\Fido\T\tcm
        Renum Max   300
End MsgArea

MsgArea TCPIP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: TCPIP Discussion
        Tag         TCPIP
        Path        J:\Msg3\Fido\T\Tcpip
        Renum Max   500
End MsgArea

MsgArea TEAMOS2
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: OS/2 User Groups & Promo
        Tag         TEAMOS2
        Path        J:\Msg3\Fido\T\teamos2
        Renum Max   500
End MsgArea

MsgArea TECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Technical Computer & Misc
        Tag         TECH
        Path        J:\Msg3\Fido\T\tech
        Renum Max   300
End MsgArea

MsgArea TEEN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: International Teenagers'
        Tag         TEEN
        Path        J:\Msg3\Fido\T\teen
        Renum Max   300
End MsgArea

MsgArea TELEMATE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Telemate
        Tag         TELEMATE
        Path        J:\Msg3\Fido\T\telemate
        Renum Max   300
End MsgArea

MsgArea TELIX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Telix Users Information Ex
        Tag         TELIX
        Path        J:\Msg3\Fido\T\telix
        Renum Max   300
End MsgArea

MsgArea TELTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Bus Tel Topics & Voice Mail
        Tag         TELTECH
        Path        J:\Msg3\Fido\T\teltech
        Renum Max   300
End MsgArea

MsgArea TENNGEN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Tennessee Geneaology
        Tag         TENNGEN
        Path        J:\Msg3\Fido\T\tenngen
        Renum Max   300
End MsgArea

MsgArea TERMINAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Terminate - I'natl Support
        Tag         TERMINAT
        Path        J:\Msg3\Fido\T\terminat
        Renum Max   300
End MsgArea

MsgArea THDPRO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: THD PROscan VirusScanr
        Tag         THDPRO
        Path        J:\Msg3\Fido\T\Thdpro
        Renum Max   500
End MsgArea

MsgArea THEBIBLE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The Bible
        Tag         THE-BIBLE
        Path        J:\Msg3\Fido\T\thebible
        Renum Max   300
End MsgArea

MsgArea THEISTWT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Atheist Watch
        Tag         THEIST_WATCH
        Path        J:\Msg3\Fido\T\theistwt
        Renum Max   300
End MsgArea

MsgArea THERSEDG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Therapy Service, Dog
        Tag         THERAPY_SERVICE_DOG
        Path        J:\Msg3\Fido\T\thersedg
        Renum Max   300
End MsgArea

MsgArea THICVA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Brain Injuries
        Tag         THI_CVA
        Path        J:\Msg3\Fido\T\thicva
        Renum Max   300
End MsgArea

MsgArea THNDRBYT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: ThunderByte Antivirus Disc
        Tag         THUNDERBYTE
        Path        J:\Msg3\Fido\T\thndrbyt
        Renum Max   300
End MsgArea

MsgArea TOONS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: General Animation Echo
        Tag         TOONS
        Path        J:\Msg3\Fido\T\toons
        Renum Max   300
End MsgArea

MsgArea TOTT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: TOTT Echo (See Elist)
        Tag         TOTT
        Path        J:\Msg3\Fido\T\tott
        Renum Max   300
End MsgArea

MsgArea TOTTROCK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: TOTT Rock ???
        Tag         TOTT_ROCK
        Path        J:\Msg3\Fido\T\Tottrock
        Renum Max   500
End MsgArea

MsgArea TOTT-SOS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: TOTT SOS ?????? Unknown
        Tag         TOTT_SOS
        Path        J:\Msg3\Fido\T\Tott-sos
        Renum Max   500
End MsgArea

MsgArea TOTTSYSP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: TOTT Sysop Echo (See Elist)
        Tag         TOTT_SYSOP
        Path        J:\Msg3\Fido\T\tottsysp
        Renum Max   300
End MsgArea

MsgArea TOURETTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Supt & Inf / Tourettes Dis.
        Tag         TOURETTES
        Path        J:\Msg3\Fido\T\touretts
        Renum Max   300
End MsgArea

MsgArea TPWTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Turbo Pascal/Win (Borland)
        Tag         TPWTECH
        Path        J:\Msg3\Fido\T\tpwtech
        Renum Max   300
End MsgArea

MsgArea TRADEWAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Trade Wars
        Tag         TRADE_WARS
        Path        J:\Msg3\Fido\T\tradewar
        Renum Max   300
End MsgArea

MsgArea TRAINS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Model Railroader
        Tag         TRAINS
        Path        J:\Msg3\Fido\T\trains
        Renum Max   300
End MsgArea

MsgArea TRAPDOOR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Trapdoor Support Echo
        Tag         TRAPDOOR
        Path        J:\Msg3\Fido\T\trapdoor
        Renum Max   300
End MsgArea

MsgArea TRAVEL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: National/International Travel
        Tag         TRAVEL
        Path        J:\Msg3\Fido\T\travel
        Renum Max   300
End MsgArea

MsgArea TREK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Star Trek
        Tag         TREK
        Path        J:\Msg3\Fido\T\trek
        Renum Max   300
End MsgArea

MsgArea TRKCREAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: TREK Creative Echo
        Tag         TREK_CREATIVE
        Path        J:\Msg3\Fido\T\Trkcreat
        Renum Max   500
End MsgArea

MsgArea TRK4SALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: TREK For Sale Echo
        Tag         TREK_FOR_SALE
        Path        J:\Msg3\Fido\T\Trk4sale
        Renum Max   500
End MsgArea

MsgArea TREKFORG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Star Trek Fan Organizations
        Tag         TREK_FAN_ORG
        Path        J:\Msg3\Fido\T\trekforg
        Renum Max   300
End MsgArea

MsgArea TREKHUMF
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:TEROK NOR:TrekHumor & Filksongs
        Tag         TREK_HUMOR_FILK
        Path        J:\Msg3\Fido\T\trekhumf
        Renum Max   300
End MsgArea

MsgArea TREKVOYA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Star Trek: Voyager Echo
        Tag         TREK_VOYAGER
        Path        J:\Msg3\Fido\T\trekvoya
        Renum Max   300
End MsgArea

MsgArea TREKTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Star Trek Technical Discussions
        Tag         TREKTECH
        Path        J:\Msg3\Fido\T\trektech
        Renum Max   300
End MsgArea

MsgArea TUB
        ACS             Sysop
        Style           *.MSG Echo Pub RealName
        Desc            FIDOnet Echo: Squish Support
        Tag             TUB
        Path            H:\Msg\Fido\Tub
        Renum Max       300
End MsgArea

MsgArea TV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Television Forum
        Tag         TV
        Path        J:\Msg3\Fido\T\tv
        Renum Max   300
End MsgArea

MsgArea TVRO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Satellite Television Echo
        Tag         TVRO
        Path        J:\Msg3\Fido\T\tvro
        Renum Max   300
End MsgArea

MsgArea TWINS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Double Trouble Conference
        Tag         TWINS
        Path        J:\Msg3\Fido\T\twins
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-U Demoted DIVISION: FidoNet Areas U-UZ

MsgArea UFGATE
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Disc Usenet-Fido Gating
        Tag         UFGATE
        Path        J:\Msg3\Fido\U\ufgate
        Renum Max   300
End MsgArea

MsgArea UFO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: UFO Topics
        Tag         UFO
        Path        J:\Msg3\Fido\U\ufo
        Renum Max   700
End MsgArea

MsgArea ULTBETA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Ultrabeta
        Tag         ULTRABETA
        Path        J:\Msg3\Fido\U\ultbeta
        Renum Max   300
End MsgArea

MsgArea UNIX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Intrntnl Fido Unix Conf
        Tag         UNIX
        Path        J:\Msg3\Fido\U\unix
        Renum Max   300
End MsgArea

MsgArea USAEURAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: USA-Europe Link
        Tag         USA_EURLINK
        Path        J:\Msg3\Fido\U\usaeural
        Renum Max   300
End MsgArea

MsgArea USRMODEM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: US Robotics Modems Echo
        Tag         USR_MODEMS
        Path        J:\Msg3\Fido\U\usrmodem
        Renum Max   300
End MsgArea

MsgArea USRSPTSR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: US Robotics Sportsters
        Tag         USR_SPORTSTERS
        Path        J:\Msg3\Fido\U\usrsptsr
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-V Demoted DIVISION: FidoNet Areas V-VZ

MsgArea VAX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: VAX Conf/Users&Mgrs of VAX
        Tag         VAX
        Path        J:\Msg3\Fido\V\vax
        Renum Max   300
End MsgArea

MsgArea VEGAN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: VEGAN (Who Knows???)
        Tag         VEGAN
        Path        J:\Msg3\Fido\V\vegan
        Renum Max   300
End MsgArea

MsgArea VFALSAC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Victims/False Accusations
        Tag         VFALSAC
        Path        J:\Msg3\Fido\V\vfalsac
        Renum Max   300
End MsgArea

MsgArea VFIDO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: VFIDO Tech Support
        Tag         VFIDO
        Path        J:\Msg3\Fido\V\vfido
        Renum Max   300
End MsgArea

MsgArea VGAPLANE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: VGA Planets Forum
        Tag         VGA.PLANETS
        Path        J:\Msg3\Fido\V\vgaplane
        Renum Max   300
End MsgArea

MsgArea VHEAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Vibrational Healing
        Tag         VHEAL
        Path        J:\Msg3\Fido\V\vheal
        Renum Max   300
End MsgArea

MsgArea VIA-SOFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: VIA Soft Software talk
        Tag         VIA_SOFT
        Path        J:\Msg3\Fido\V\Via-soft
        Renum Max   500
End MsgArea

MsgArea VIDEO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: VIDEO-TOASTER Support Echo
        Tag         VIDEO
        Path        J:\Msg3\Fido\V\video
        Renum Max   300
End MsgArea

MsgArea VIDGAME
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Video Games
        Tag         VID_GAME
        Path        J:\Msg3\Fido\V\vidgame
        Renum Max   300
End MsgArea

MsgArea VIETNAMV
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: VIETNAM_VETS
        Tag         VIETNAM_VETS
        Path        J:\Msg3\Fido\V\vietnamv
        Renum Max   300
End MsgArea

MsgArea VINMAISN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Home Winemaking
        Tag         VIN_MAISON
        Path        J:\Msg3\Fido\V\vinmaisn
        Renum Max   300
End MsgArea

MsgArea VIRUS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Virus Conference
        Tag         VIRUS
        Path        J:\Msg3\Fido\V\virus
        Renum Max   300
End MsgArea

MsgArea VIRUSINF
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Virus (Computer) Info
        Tag         VIRUS_INFO
        Path        J:\Msg3\Fido\V\virusinf
        Renum Max   300
End MsgArea

MsgArea VIRUSNFO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Computer Virus Topics
        Tag         VIRUS_NFO
        Path        J:\Msg3\Fido\V\virusnfo
        Renum Max   300
End MsgArea

MsgArea VISUALBA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Visual Basic Echo
        Tag         VISUAL_BASIC
        Path        J:\Msg3\Fido\V\visualba
        Renum Max   300
End MsgArea

MsgArea VOCAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Vocal (?)
        Tag         VOCAL
        Path        J:\Msg3\Fido\V\vocal
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-W Demoted DIVISION: FidoNet Areas W-WZ

MsgArea WARNING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Warning <?????>
        Tag         WARNING
        Path        J:\Msg3\Fido\W\Warning
        Renum Max   500
End MsgArea

MsgArea WDRUGPLC
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: World Drug Policies
        Tag         WORLD.DRUG.POLICY
        Path        J:\Msg3\Fido\W\Wdrugplc
        Renum Max   300
End MsgArea

MsgArea WELFARE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Welfare Conference
        Tag         WELFARE
        Path        J:\Msg3\Fido\W\welfare
        Renum Max   300
End MsgArea

MsgArea WGW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Genealogy Forum
        Tag         WGW
        Path        J:\Msg3\Fido\W\wgw
        Renum Max   300
End MsgArea

MsgArea WHIRBIRD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Helicopter Enthusiasts
        Tag         WHIRLYBIRDS
        Path        J:\Msg3\Fido\W\whirbird
        Renum Max   300
End MsgArea

MsgArea WHITEHOU
        ACS         Normal
        Style       Squish Echo ReadOnly Pub Audit
        Desc        FIDOnet Echo: White House Press Rele
        Tag         WHITEHOUSE
        Path        J:\Msg3\Fido\W\whitehou
        Renum Max   300
End MsgArea

MsgArea WHO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo:Int'l DoctorWho/Brit SFTV
        Tag         WHO
        Path        J:\Msg3\Fido\W\who
        Renum Max   300
End MsgArea

MsgArea WHOLLYBI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Biblical Disc. & Related
        Tag         WHOLLY_BIBLE
        Path        J:\Msg3\Fido\W\whollybi
        Renum Max   300
End MsgArea

MsgArea WILDRNSS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Wilderness Travel
        Tag         WILDRNSS
        Path        J:\Msg3\Fido\W\wildrnss
        Renum Max   300
End MsgArea

MsgArea WIN32
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Microsoft WIN32 OS
        Tag         WIN32
        Path        J:\Msg3\Fido\W\win32
        Renum Max   300
End MsgArea

MsgArea WIN95
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Windows 95 (?)
        Tag         WIN95
        Path        J:\Msg3\Fido\W\win95
        Renum Max   300
End MsgArea

MsgArea WINACCES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Microsoft Access for Win
        Tag         WIN_ACCESS
        Path        J:\Msg3\Fido\W\winacces
        Renum Max   300
End MsgArea

MsgArea WINDOWS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Windows
        Tag         WINDOWS
        Path        J:\Msg3\Fido\W\windows
        Renum Max   300
End MsgArea

MsgArea WNFOSSIL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Windows FOSSIL Drivers Disc.
        Tag         WNFOSSIL
        Path        J:\Msg3\Fido\W\Wnfossil
        Renum Max   500
End MsgArea

MsgArea WINNTUSR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Windows NT Users
        Tag         WINNTUSER
        Path        J:\Msg3\Fido\W\Winntusr
        Renum Max   500
End MsgArea

MsgArea WINSYSOP
        ACS         Extra
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Windows Sysops
        Tag         WIN.SYSOP
        Path        J:\Msg3\Fido\W\winsysop
        Renum Max   300
End MsgArea

MsgArea WORDWORD
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: The FidoNet Words Conf
        Tag         WORDS_WORDS
        Path        J:\Msg3\Fido\W\wordword
        Renum Max   300
End MsgArea

MsgArea WORDSTAR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: WordStar International Users
        Tag         WORDSTAR
        Path        J:\Msg3\Fido\W\wordstar
        Renum Max   300
End MsgArea

MsgArea WORLDTLK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: World Talk Conf & UN News
        Tag         WORLDTLK
        Path        J:\Msg3\Fido\W\worldtlk
        Renum Max   300
End MsgArea

MsgArea WPCRAFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: WordPerf Supt/Indivl Users
        Tag         WP-CRAFT
        Path        J:\Msg3\Fido\W\wpcraft
        Renum Max   300
End MsgArea

MsgArea WPTOOLS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: WordPerfTool & Macro Devl.
        Tag         WP-TOOLS
        Path        J:\Msg3\Fido\W\wptools
        Renum Max   300
End MsgArea

MsgArea WPERFECT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: WordPerfect Products Disc.
        Tag         WPERFECT
        Path        J:\Msg3\Fido\W\wperfect
        Renum Max   300
End MsgArea

MsgArea WRESTLE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Fido Pro Wrestling (FPW)
        Tag         WRESTLING
        Path        J:\Msg3\Fido\W\wrestle
        Renum Max   300
End MsgArea

MsgArea WRSTLRPG
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Wrestling RPG's
        Tag         WRESTLE_RPG
        Path        J:\Msg3\Fido\W\wrstlrpg
        Renum Max   500
End MsgArea

MsgArea WUNDERMT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: SF,Fantasy,Filk,Fen,Faire,etc
        Tag         WUNDERMENT
        Path        J:\Msg3\Fido\W\wundermt
        Renum Max   300
End MsgArea

MsgArea WRITING
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Writing Conf.
        Tag         WRITING
        Path        J:\Msg3\Fido\W\writing
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-XY Demoted DIVISION: FidoNet Areas X-YZ

MsgArea X00USER
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: X00 Fossil Echo
        Tag         X00_USER
        Path        J:\Msg3\Fido\X\x00user
        Renum Max   300
End MsgArea

MsgArea XENIA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Xenia Mail Tosser
        Tag         XENIA
        Path        J:\Msg3\Fido\X\Xenia
        Renum Max   500
End MsgArea

MsgArea XFILES
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: X-Files Discussion
        Tag         X-FILES
        Path        J:\Msg3\Fido\X\xfiles
        Renum Max   300
End MsgArea

MsgArea XPRSSUPP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Silver Xpress OPX/QWK Reader
        Tag         XPRESS_SUPPORT
        Path        J:\Msg3\Fido\X\xprssupp
        Renum Max   300
End MsgArea

MsgArea XPRSSYSO
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Silver Xpress OPX/QWK Mail
        Tag         XPRESS_SYSOP
        Path        J:\Msg3\Fido\X\xprssyso
        Renum Max   300
End MsgArea

MsgArea YOUNGADU
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Young Adult Forum
        Tag         YOUNG_ADULT
        Path        J:\Msg3\Fido\Y\youngadu
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin Fido-Z Demoted DIVISION: FidoNet Areas Z-ZZ

MsgArea Z1BACKBN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Zone 1 Mail Backbone - Users
        Tag         Z1_BACKBONE
        Path        J:\Msg3\Fido\Z\z1backbn
        Renum Max   300
End MsgArea

MsgArea Z1-CHAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Zone 1 CHAT
        Tag         Z1_CHAT
        Path        J:\Msg3\Fido\Z\Z1-chat
        Renum Max   500
End MsgArea

MsgArea Z1ELECTN
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FidoNET Echo: Zone 1 Elections
        Tag         Z1_ELECTION
        Path        J:\Msg3\Fido\Z\Z1electn
        Renum Max   300
End MsgArea

MsgArea Z1POLITI
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Zone 1 Disc MsgArea/Sysop
        Tag         Z1_POLITICAL
        Path        J:\Msg3\Fido\Z\z1politi
        Renum Max   300
End MsgArea

MsgArea ZEC
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Zone 1 Echomail Coord
        Tag         ZEC
        Path        J:\Msg3\Fido\Z\zec
        Renum Max   300
End MsgArea

MsgArea ZMODEM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Zmodem help
        Tag         ZMODEM
        Path        J:\Msg3\Fido\Z\zmodem
        Renum Max   300
End MsgArea

MsgArea ZOOM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Zoom Modems Echo
        Tag         ZOOM
        Path        J:\Msg3\Fido\Z\zoom
        Renum Max   300
End MsgArea

MsgArea ZYMURGY
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Home Brewing
        Tag         ZYMURGY
        Path        J:\Msg3\Fido\Z\zymurgy
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionend

msgdivisionbegin 3 Demoted DIVISION: FidoNet Local Areas

MsgArea HUB25
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: HUB 25 Topics
        Tag         HUB25
        Path        J:\Msg3\Sp\Hub25
        Renum Max   300
End MsgArea

MsgArea 346COM
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Comm Echo for net 1:346
        Tag         346COM
        Path        J:\Msg3\Sp\346com
        Renum Max   300
End MsgArea

MsgArea 346TEST
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: 346 Test Echo
        Tag         346_TEST
        Path        J:\Msg3\Sp\346test
        Renum Max   300
End MsgArea

MsgArea SPOARTS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane ARTS echo
        Tag         SPO-ARTS
        Path        J:\Msg3\Sp\spoarts
        Renum Max   300
End MsgArea


MsgArea SPOBIBLE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane Bible COnf
        Tag         SPO-BIBLE
        Path        J:\Msg3\Sp\spobible
        Renum Max   200
End MsgArea

MsgArea SPOCHAT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane CHAT echo
        Tag         SPO-CHAT
        Path        J:\Msg3\Sp\spochat
        Renum Max   300
End MsgArea

MsgArea SPO-COOK
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        Spokane Echo: Cooking
        Tag         SPO-COOK
        Path        J:\Msg3\Sp\Spo-cook
        Renum Max   500
End MsgArea

MsgArea SPOCRAFT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane CRAFT echo
        Tag         SPO-CRAFT
        Path        J:\Msg3\Sp\spocraft
        Renum Max   300
End MsgArea

MsgArea SPOCSALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane Computer Sale
        Tag         SPO-CSALE
        Path        J:\Msg3\Sp\spocsale
        Renum Max   300
End MsgArea

MsgArea SPOFILE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane Files Echo
        Tag         SPO-FILE
        Path        J:\Msg3\Sp\Spofile
        Renum Max   500
End MsgArea

MsgArea SPOFLAME
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane Flame Echo
        Tag         SPO-FLAME
        Path        J:\Msg3\Sp\spoflame
        Renum Max   300
End MsgArea

MsgArea SPOHAM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane HAM Operator Echo
        Tag         SPO-HAM
        Path        J:\Msg3\Sp\spoham
        Renum Max   300
End MsgArea

MsgArea SPOJOKE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane Joke Echo
        Tag         SPO-JOKE
        Path        J:\Msg3\Sp\spojoke
        Renum Max   300
End MsgArea

MsgArea SPOLIT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane Literary Echo
        Tag         SPO-LITERARY
        Path        J:\Msg3\Sp\spolit
        Renum Max   300
End MsgArea

MsgArea SPOSALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane ForSale Echo
        Tag         SPO-SALE
        Path        J:\Msg3\Sp\sposale
        Renum Max   300
End MsgArea

MsgArea SPOSYSOP
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane Sysop Echo
        Tag         SPO-SYSOP
        Path        J:\Msg3\Sp\sposysop
        Renum Max   300
End MsgArea

MsgArea SPOTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Spokane Tech
        Tag         SPO-TECH
        Path        J:\Msg3\Sp\spotech
        Renum Max   300
End MsgArea

MsgArea CITYHALL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: City Hall
        Tag         CITYHALL
        Path        J:\Msg3\Sp\cityhall
        Renum Max   200
End MsgArea

MsgArea LIBNW
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Lib-NW
        Tag         LIB_NW
        Path        J:\Msg3\Sp\lib_nw
        Renum Max   200
End MsgArea

MsgArea SPO-BBS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        Spokane BBS Lists, Ads, Etc
        Tag         SPO-BBS
        Path        J:\Msg3\Sp\Spobbs
        Renum Max   500
End MsgArea

MsgArea SPO-WX
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        Spokane Echo: Spokane Weather
        Tag         SPO-WX
        Path        J:\Msg3\Sp\Spo-wx
        Renum Max   500
End MsgArea

msgdivisionend

msgdivisionbegin 4 Demoted DIVISION: Pacific NorthWest Fido Areas

MsgArea PNWBELL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pacific NW Phone Disc
        Tag         PNW.BELL
        Path        J:\Msg3\REGN17\pnwbell
        Renum Max   300
End MsgArea

MsgArea PNWCHATR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pacific NW Chatter
        Tag         PNW.CHATTER
        Path        J:\Msg3\REGN17\pnwchatr
        Renum Max   300
End MsgArea

MsgArea PNWGENRL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pacific NW General
        Tag         PNW.GENERAL
        Path        J:\Msg3\REGN17\pnwgenrl
        Renum Max   300
End MsgArea

MsgArea PNWNEWS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pacific NW News
        Tag         PNW.NEWS
        Path        J:\Msg3\REGN17\pnwnews
        Renum Max   300
End MsgArea

MsgArea PNWOUTDR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pacific NW Outdoors
        Tag         PNW.OUTDOORS
        Path        J:\Msg3\REGN17\pnwoutdr
        Renum Max   300
End MsgArea

MsgArea PNW4SALE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pacific NW 4 Sale
        Tag         PNW.FORSALE
        Path        J:\Msg3\REGN17\pnw4sale
        Renum Max   300
End MsgArea

MsgArea PNWTECH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: Pacific NW Tech
        Tag         PNW.TECH
        Path        J:\Msg3\REGN17\pnwtech
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin 5 Demoted DIVISION: Region 17 Fido Areas

MsgArea RGN17
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Region 17 Echo
        Tag         RGN17
        Path        J:\Msg3\Regn17\rgn17
        Renum Max   300
End MsgArea

MsgArea CELBLK17
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Region 17 Echo
        Tag         CELLBLK17
        Path        J:\Msg3\Regn17\celblk17
        Renum Max   300
End MsgArea

MsgArea MOOSECHT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Region 17 Echo
        Tag         MOOSECHAT
        Path        J:\Msg3\Regn17\moosecht
        Renum Max   300
End MsgArea

MsgArea TESTRG17
        ACS         Sysop
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Region 17 Echo
        Tag         TEST_RGN17
        Path        J:\Msg3\Regn17\testrg17
        Renum Max   300
End MsgArea

MsgArea THCURNET
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Region 17 Echo
        Tag         THE_CURE_NETWORK
        Path        J:\Msg3\Regn17\thcurnet
        Renum Max   300
End MsgArea

MsgArea WA-GOVT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        FIDOnet Echo: FidoNet Region 17 Echo
        Tag         WA_GOVT
        Path        J:\Msg3\Regn17\wa-govt
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin 6 Demoted DIVISION: FidoNet NetMail / Internet EMAIL

MsgArea NET
        % This defines your primary NetMail area, accessible with an
        % area "number" of NET.  This area will be stored in the *.MSG
        % format, since most external programs require the *.MSG format
        % for NetMail.

        Style       *.MSG Net Pvt RealName
        ACS         Normal
        Desc        NetMail
        Path        G:\Bink\Netmail

        % Note:  the "Renum Max" keyword applies only to MaxRen.  If
        % you're using a secondary renumbering utility, and that
        % utility does NOT support the "Renum Max" keyword in MSGAREA.CTL,
        % you may need to specify the maximum number of messages again
        % for other, external renumbering programs.

        Renum Max   200
End MsgArea

MsgArea EMAIL
        Style       *.MSG Net Pvt RealName Attach
        ACS         Normal
        Desc        Internet Email
        Path        G:\Bink\Email
        Renum Max   300
End MsgArea

msgdivisionend

msgdivisionbegin 7 Demoted DIVISION: Internet UseNet NewsGroups

MsgArea AALIENRS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.ALIEN.RESEARCH
        Tag         ALT.ALIEN.RESEARCH
        Path        K:\Msg4\Usenet\aalienrs
        Renum Max   300
End MsgArea

MsgArea AALIENVI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.ALIEN.VISITORS
        Tag         ALT.ALIEN.VISITORS
        Path        K:\Msg4\Usenet\aalienvi
        Renum Max   300
End MsgArea

MsgArea AALIENIM
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.ALIENS.IMPRISONED
        Tag         ALT.ALIENS.IMPRISONED
        Path        K:\Msg4\Usenet\aalienim
        Renum Max   300
End MsgArea

MsgArea AHUMPUNS
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.HUMOR.PUNS
        Tag         ALT.HUMOR.PUNS
        Path        K:\Msg4\Usenet\ahumpuns
        Renum Max   300
End MsgArea

MsgArea APABDUCT
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANET.ABDUCT
        Tag         ALT.PARANET.ABDUCT
        Path        K:\Msg4\Usenet\apabduct
        Renum Max   300
End MsgArea

MsgArea APMETAPH
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANET.METAPHYSICS
        Tag         ALT.PARANET.METAPHYSICS
        Path        K:\Msg4\Usenet\apmetaph
        Renum Max   300
End MsgArea

MsgArea APPARANO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANET.PARANORMAL
        Tag         ALT.PARANET.PARANORMAL
        Path        K:\Msg4\Usenet\apparano
        Renum Max   300
End MsgArea

MsgArea APNETPSI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANET.PSI
        Tag         ALT.PARANET.PSI
        Path        K:\Msg4\Usenet\apnetpsi
        Renum Max   300
End MsgArea

MsgArea APNETSCI
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANET.SCIENCE
        Tag         ALT.PARANET.SCIENCE
        Path        K:\Msg4\Usenet\apnetsci
        Renum Max   300
End MsgArea

MsgArea APNETSKE
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANET.SKEPTIC
        Tag         ALT.PARANET.SKEPTIC
        Path        K:\Msg4\Usenet\apnetske
        Renum Max   300
End MsgArea

MsgArea APNETUFO
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANET.UFO
        Tag         ALT.PARANET.UFO
        Path        K:\Msg4\Usenet\apnetufo
        Renum Max   300
End MsgArea

MsgArea APNORMAL
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANORMAL
        Tag         ALT.PARANORMAL
        Path        K:\Msg4\Usenet\apnormal
        Renum Max   300
End MsgArea

MsgArea APNORCHA
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.PARANORMAL.CHANNELING
        Tag         ALT.PARANORMAL.CHANNELING
        Path        K:\Msg4\Usenet\apnorcha
        Renum Max   300
End MsgArea

MsgArea AUFOREP
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        UseNET: ALT.UFO.REPORTS
        Tag         ALT.UFO.REPORTS
        Path        K:\Msg4\Usenet\auforep
        Renum Max   300
End MsgArea

MsgArea RECHUMFN
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        Usenet Echo: REC.HUMOR.FUNNY
        Tag         REC.HUMOR.FUNNY
        Path        K:\Msg4\Usenet\Redhumfn
        Renum Max   500
End MsgArea

MsgArea WASHGENR
        ACS         Normal
        Style       Squish Echo Pub RealName Audit
        Desc        Usenet Echo: WASH.GENERAL
        Tag         WASH.GENERAL
        Path        K:\Msg4\Usenet\Washgenr
        Renum Max   500
End MsgArea

msgdivisionend

MsgArea Max2Net
        ACS         Privil
        Style       *.MSG Pvt RealName Matrix
        Desc        NetMail Reply to EchoMail
        Tag         Max2Net
        Path        G:\Max\Max2Net
        Barricade   G:\Max\Max2net\username.bcd
        Renum Max   200
End MsgArea

