/************************************************************************
 * jcal.c Calander program for Science Club BBS in OMAN
 *  SCIENCE CLUB BBS +968 593-728  28800 USR Sposter
 * - FREEWARE - no rights reserved
 *
 * Can be compiled with Watcom : wcl -bt=dos -l=dos jcal.c getopt.c
 * or with gcc on Linux: cc -O -s -o jcal jcal.c
 *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <getopt.h>
#ifndef __unix__
 extern char *optarg;
 extern int optind;
#endif

#define FEB 1

#define TC    209
#define BC    207
#define CC    197
#define VBAR  179
#define HBAR  196
#define LVB   199
#define RVB   182
#define DHBAR 205
#define DVBAR 186
#define DLTC  201
#define DRTC  187
#define DLBC  200
#define DRBC  188

#define TWID 34

short BG=7;
short FG=4;
short XG=1;
short CS=22;

static void newline (void)
{
#ifdef __unix__
    fputs("\033E", stdout);
#else
    fputs("\033[0m\033[0K\n", stdout);
#endif
}

static void SetCols(void)
{
    printf("\033[0;4%d;3%dm", BG, FG);		    
}

void pad(short n, char fill, short flag)
{
    if(flag & 1)
    {
	printf("\033[%d;3%dm", (FG & 8) >> 3, FG & 7);
    }
    
    while(n--)
    {
         putchar(' ');
    }

    if(flag & 2)
    {
	printf ("\033[4%dm", BG);
    }

    if(fill == '\n')
    {
	newline();
    }
    else if(fill)
    {
         putchar(fill);
    }
}


void Divide(char left, char mid, char div, char right)
{
    short k;
    short l;
    
    pad(CS, left, 3);

    l = 79 - CS*2;
    
    for(k = 1; k < l; k++)
    {
	if((k % 5) == 0)
	{
	    putchar(div);
	}
	else
	{
	    putchar(mid);
	}
    }
    putchar(right);
    pad (0, '\n', 1);
}

int main(int ac, char **av)
{
    char buf[80];
    time_t t;
    struct tm *tm;
    auto const char daysof[]={31,28,31,30,31,30,
					 31,31,30,31,30,31
				 };
    short leap;
    short lday;
    short first,i,j;
    char *efile = NULL;
    char *epilogue = NULL;
    char *prolog = NULL;    
    int c;

    while ((c = getopt(ac, av, "f:b:x:p:e:")) != EOF)
    {
	switch (c)
	  {
	  case 'c':
	    FG = atoi(optarg);
	    break;
	  case 'b':
	    BG = atoi(optarg);
	    break;
	  case 'x':
	    XG = atoi(optarg);
	    break;
	  case 'p':
	    prolog = strdup(optarg);
	    break;
	  case 'e':
	    epilogue = strdup(optarg);
	    break;
	  }
    }		

    if(optind < ac)
    {
      efile = strdup(*(av+optind));
    }
    
    t = time(NULL);

    tm = localtime(&t);
    leap = (tm->tm_year % 4 == 0);         /* 2000 is a leap year ! */
    strftime(buf, sizeof(buf), "%B %Y", tm);

    if(prolog)
    {
	fputs(prolog, stdout);
	free(prolog);
    }
    putchar('\n');
    SetCols();    
    Divide(DLTC, DHBAR, DHBAR, DRTC);

    j = strlen(buf);
    i = (34 - j)/2;
    pad(CS, DVBAR, 3);
    pad(i, 0, 0);
    
    printf("\033[30m%*s\033[3%dm", 
	   j, buf, FG);
    pad(34-i-j, DVBAR, 2);
    putchar ('\n');

    Divide(204, DHBAR, DHBAR, 185);
    pad (CS, DVBAR, 3);
    printf("\033[30m Su   Mo   Tu   We   Th   Fr   Sa \033[3%dm",
	   FG);
    putchar(DVBAR);
    pad(0, '\n', 1);
    Divide(LVB, HBAR, 194, RVB);    
    lday = daysof[tm->tm_mon];
    if(tm->tm_mon == FEB)
    {
	lday += leap;
    } 
    first = tm->tm_wday + 1 - (tm->tm_mday % 7);
    if(first < 0) first += 7;

    first = first % 7;

    pad(CS, DVBAR, 3);

    for(j = i = 0; ; i++)
    {
	if(i < first)
	{
	    printf ("    %c", VBAR);
	}
	else
	{
	    if(j < lday)
	    {
		j++;
		if(j == tm->tm_mday)
		{
		    printf("\x1b[1;3%dm", XG);
		}
		else
		{
		    fputs("\x1b[1;30m", stdout);
		}
		
		printf(" %2d ", j);
		SetCols();
	    }
	    else 
	    {
		fputs("    ", stdout);
	    }
	    
	    if(((i+1) % 7) == 0)
	    {
		putchar(DVBAR);
                putchar ('\n');

		if(j < lday)
		{
		    Divide(LVB, HBAR, CC, RVB);
		    pad (CS, DVBAR, 3);
		}
		else
		{
		    Divide(DLBC, DHBAR, BC, DRBC);
		    break;
		}
	    }
	    else
	    {
		putchar(VBAR);
	    }
	}
    }

    if(efile)
    {
	FILE *fp;
	putchar ('\n');
	if(fp = fopen(efile, "r"))
	{
	    short nl = 0;
	    short mx = 0;
	    char txt[82];
	    while(fgets(txt, sizeof(txt), fp))
	    {
		char *p;
		short n;
		
		if(p = strchr(txt, '\n'))
		{
		    *p = '\0';
		}
		n = strlen(txt);
		if(n)
		{
		    nl++;
		    if(n > mx)
		    {
			mx = n;
		    }
		}
	    }
	    if(nl)
	    {
		short sfg;
		
                pad(32, 0, 3);
		fputs (" Today's Events ", stdout);
		pad(0, '\n', 1);
		rewind(fp);
		mx = (mx + 3) & ~1;
		CS = 39 - (mx >> 1);
		sfg = FG;
		FG = 15;
		Divide(218, 196, 196, 191);
		FG = sfg;
		
		printf("\033[0;4%dm", BG);
		while(fgets(txt, sizeof(txt), fp))
		{
		    char *p;
		    if(p = strchr(txt, '\n'))
		    {
			*p = '\0';
		    }
		    if(strlen(txt))
		    {
			pad(CS, 0, 3);
			printf("\033[1;37;4%dm\263\033[0;30;4%dm ", 
			       BG, BG);
			printf("%-*.*s \263", mx-2, mx-2, txt);
			pad(0, '\n', 1);
		    }
		}
		sfg = FG;
		FG = 8;
		Divide(192, 196, 196, 217);
		FG = sfg;
	    }
	    fclose(fp);
	    free(efile);
	}
    }
    puts("\033[0m");

    if(epilogue)
    {
	fputs(epilogue, stdout);
	free(epilogue);
	putchar('\n');
    }
    
    return 0;    
}



